% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmat_utils.R
\name{normalizeVmat}
\alias{normalizeVmat}
\title{A function to normalized a Vmat}
\usage{
normalizeVmat(
  Vmat,
  bam_granges,
  granges,
  normFun = c("zscore"),
  s = 0.99,
  roll = 1,
  verbose = TRUE
)
}
\arguments{
\item{Vmat}{A Vmat, usually output of computeVmat}

\item{bam_granges}{GRanges, the paired-end fragments}

\item{granges}{GRanges, the regions to map the fragments onto}

\item{normFun}{character. A Vmat should be scaled either by:
\itemize{
    \item 'libdepth+nloci', e.g. the library depth and the number of 
    loci used to compute the Vmat;
    \item zscore, if relative patterns of fragment density 
    are more important than density per se;
    \item Alternatively, the Vmat can be scaled to % ('pct'), to 
    a chosen quantile ('quantile') or to the max Vmat value ('max').
}}

\item{s}{A float indicating which quantile to use if 'quantile'
normalization is chosen}

\item{roll}{integer, to use as the window to smooth the Vmat rows 
by rolling mean.}

\item{verbose}{Boolean}
}
\value{
A normalized Vmat object
}
\description{
This function normalizes a Vmat. Several different approaches have 
been implemented to normalize the Vmats.
}
\examples{
data(bam_test)
data(ce11_all_REs)
Vmat <- computeVmat(bam_test, ce11_all_REs)
Vmat <- normalizeVmat(
    Vmat, 
    bam_test, 
    ce11_all_REs,
    normFun = c('libdepth+nloci')
)
}
