% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_clusters.R
\name{compare_clusters}
\alias{compare_clusters}
\alias{compare_clusters,list-method}
\title{Heatmap to compare partitions}
\usage{
compare_clusters(clusters)

\S4method{compare_clusters}{list}(clusters)
}
\arguments{
\item{clusters}{a \code{list} of named \code{\link{GO_clusters-class}} objects,
from \code{\link{GOterms_heatmap}} or \code{\link{GOclusters_heatmap}} methods.}
}
\value{
an interactive javascript heatmap.
}
\description{
Build an interactive heatmap of the common GO terms frequency between several partitions.
}
\details{
Build an interactive heatmap of common GO terms frequency between partitions from several
\code{\link{GO_clusters-class}} objects.
}
\examples{
# load example object
data(
    myGOs,
    package="ViSEAGO"
)

\dontrun{
# compute Semantic Similarity (SS)
myGOs<-ViSEAGO::compute_SS_distances(
    myGOs,
    distance=c("Resnik","Lin","Rel","Jiang","Wang")
)

# Resnik distance GO terms heatmap
Resnik_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Resnik",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Lin distance GO terms heatmap
Lin_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Lin",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Resnik distance GO terms heatmap
Rel_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Rel",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Resnik distance GO terms heatmap
Jiang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Jiang",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Resnik distance GO terms heatmap
Wang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Wang",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)
}

# clusters to compare
clusters<-list(
    Resnik="Resnik_clusters_wardD2",
    Lin="Lin_clusters_wardD2",
    Rel="Rel_clusters_wardD2",
    Jiang="Jiang_clusters_wardD2",
    Wang="Wang_clusters_wardD2"
)

\dontrun{
# clusters content comparisons
clusters_comp<-ViSEAGO::compare_clusters(clusters)
}
}
\references{
Carson Sievert, Chris Parmer, Toby Hocking, Scott Chamberlain, Karthik Ram, Marianne Corvellec and Pedro Despouy (2017).
 plotly: Create Interactive Web Graphics via 'plotly.js'. R package version 4.6.0. https://CRAN.R-project.org/package=plotly
}
\seealso{
Other GO_clusters: 
\code{\link{GO_clusters-class}},
\code{\link{GOclusters_heatmap}()},
\code{\link{clusters_cor}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}
}
\concept{GO_clusters}
