% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOcount.R
\name{GOcount}
\alias{GOcount}
\alias{GOcount,ANY-method}
\title{Barplot for the count of GO terms.}
\usage{
GOcount(object, file = NULL)

\S4method{GOcount}{ANY}(object, file = NULL)
}
\arguments{
\item{object}{an \code{\link{enrich_GO_terms-class}} object from \code{\link{merge_enrich_terms}} method.}

\item{file}{the name of the output file (default to NULL for interactive screen display).}
}
\value{
a barplot.
}
\description{
This method displays in barplot the count of GO terms splitted in two categories (significant or not)
for each result of GO enrichment tests.
}
\details{
This method displays an interactive barplot, using \pkg{plotly} package, from a \code{\link{merge_enrich_terms}}
output object.\cr
A static image (in png) could be printed by setting \code{file} argument.
}
\examples{
# load object
utils::data(
 myGOs,
 package="ViSEAGO"
)

# barplot for the count of GO terms
ViSEAGO::GOcount( myGOs)
}
\references{
Carson Sievert, Chris Parmer, Toby Hocking, Scott Chamberlain, Karthik Ram, Marianne Corvellec and Pedro Despouy (2017).
plotly: Create InteractiveWeb Graphics via 'plotly.js'. R package version 4.6.0. https://CRAN.R-project.org/package=plotly.
}
\seealso{
Other GO_terms: 
\code{\link{GOterms_heatmap}()},
\code{\link{annotate}()},
\code{\link{create_topGOdata}()},
\code{\link{gene2GO-class}},
\code{\link{merge_enrich_terms}()},
\code{\link{runfgsea}()}

Other visualization: 
\code{\link{GOclusters_heatmap}()},
\code{\link{GOterms_heatmap}()},
\code{\link{Upset}()},
\code{\link{available_organisms}()},
\code{\link{overLapper}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}
}
\concept{GO_terms}
\concept{visualization}
