% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bioconductor2GO.R
\name{Bioconductor2GO}
\alias{Bioconductor2GO}
\title{Check available organisms databases at Bioconductor.}
\usage{
Bioconductor2GO()
}
\value{
a  \code{\link{genomic_ressource-class}} object required by \code{\link{annotate}} method.
}
\description{
Retrieve the Bioconductor \href{http://bioconductor.org/packages/release/BiocViews.html#___OrgDb}{OrgDb}
available organisms databases packages.
}
\details{
This function gives genome wide annotation for available organisms databases packages from
\href{http://bioconductor.org/packages/release/BiocViews.html#___OrgDb}{Bioconductor OrgDb}.
It uses \code{loadAnnDbPkgIndex} from \pkg{AnnotationForge} package.
}
\examples{
# Check Bioconductor OrgDb available organisms
Bioconductor<-ViSEAGO::Bioconductor2GO()
}
\references{
Carlson M and Pages H (2017). AnnotationForge: Code for Building Annotation Database Packages. R package version 1.18.0.
}
\seealso{
Other genomic_ressource: 
\code{\link{Custom2GO}()},
\code{\link{Ensembl2GO}()},
\code{\link{EntrezGene2GO}()},
\code{\link{Uniprot2GO}()},
\code{\link{annotate}()},
\code{\link{available_organisms}()},
\code{\link{genomic_ressource-class}},
\code{\link{taxonomy}()}
}
\concept{genomic_ressource}
