% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/misc.R
\name{rowjoin}
\alias{rowjoin}
\alias{rowjoin,data.frame,data.frame-method}
\title{Join data.frames by row names or specified columns}
\usage{
rowjoin(x, y, fun = "full_join", by = NULL)

\S4method{rowjoin}{data.frame,data.frame}(x, y, fun = "full_join")
}
\arguments{
\item{x}{data.frame x}

\item{y}{data.frame y}

\item{fun}{Different join format: left_join, full_join, right_join
(default:full_join)}

\item{by}{Optional vector of column names to join by}
}
\value{
A joined data.frame

dataframe with join results
}
\description{
Joins two data.frames using various join methods

join two dataframes by rownames
}
\examples{
library(dplyr)
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
dA <- data.frame(A = A, "FC" = rnorm(40))
dB <- data.frame(B = B, "FC" = rnorm(60))
rownames(dA) <- A
rownames(dB) <- B
# Full join by row names
result <- rowjoin(dA, dB)
# Left join by row names
result <- rowjoin(dA, dB, fun = "left_join")
library(dplyr)
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
dA <- data.frame(A = A, "FC" = rnorm(40))
dB <- data.frame(B = B, "FC" = rnorm(60))
rownames(dA) <- A
rownames(dB) <- B
rowjoin(dA, dB)
}
\author{
Kai Guo
}
