% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge.Venn}
\alias{merge.Venn}
\title{Utility functions for VennDetail package}
\usage{
\method{merge}{Venn}(x, y, ignore.case = FALSE, useupper = TRUE, plot = FALSE, ...)
}
\arguments{
\item{x}{First Venn object}

\item{y}{Second Venn object}

\item{ignore.case}{Logical: ignore case in group names? Default: FALSE}

\item{useupper}{Logical: convert all group names to upper case? Default: TRUE}

\item{plot}{Logical: plot the combined result? Default: FALSE}

\item{...}{Additional arguments passed to venndetail}
}
\value{
A new Venn object combining the input objects
}
\description{
Internal utility functions for the VennDetail package

Combines multiple Venn objects into a single Venn object
}
\examples{
# Create two Venn objects
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res1 <- venndetail(list(A = A, B = B))
res2 <- venndetail(list(A = A, C = C))

# Merge the two objects
res <- merge(res1, res2)

# Plot the merged result
plot(res)
}
\author{
Kai Guo
}
