% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-SnpArrayExperiment.R
\name{snpArrayAssays}
\alias{snpArrayAssays}
\title{Create an assays object from log R ratios and B allele frequencies}
\usage{
snpArrayAssays(cn = new("matrix"), baf = new("matrix"), ...)
}
\arguments{
\item{cn}{matrix of log R ratios}

\item{baf}{matrix of B allele frequencies}

\item{...}{additional matrices of the same dimension, such as SNP genotypes.}
}
\description{
This function is exported primarily for internal use by other BioC
packages.
}
\examples{
data(snp_exp, package="VanillaICE")
r <- lrr(snp_exp)
b <- baf(snp_exp)
sl <- snpArrayAssays(cn=r, baf=b)
}
