% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-HMM.R,
%   R/methods-HMMList.R, R/methods-HmmGRanges.R
\name{cnvFilter}
\alias{cnvFilter}
\alias{cnvFilter,HMM-method}
\alias{cnvFilter,GRanges-method}
\alias{cnvSegs}
\alias{duplication}
\alias{duplication,HMM-method}
\alias{deletion}
\alias{deletion,HMM-method}
\alias{hemizygous}
\alias{hemizygous,HMM-method}
\alias{homozygous}
\alias{homozygous,HMM-method}
\alias{cnvSegs,HMM-method}
\alias{segs,HMMList-method}
\alias{hemizygous,HMMList-method}
\alias{homozygous,HMMList-method}
\alias{duplication,HMMList-method}
\alias{cnvSegs,HMMList-method}
\alias{cnvFilter,HMMList-method}
\alias{cnvSegs,HmmGRanges-method}
\title{Filter the HMM-derived genomic ranges for copy number variants}
\usage{
cnvFilter(object, filters = FilterParam())

cnvSegs(object, filters = FilterParam(state = c("1", "2", "5", "6")))

duplication(object, filters = FilterParam(state = c("5", "6")))

deletion(object, filters = FilterParam(state = c("1", "2")))

hemizygous(object, filters = FilterParam(state = "2"))

homozygous(object, filters = FilterParam(state = "1"))

\S4method{cnvSegs}{HMM}(object, filters = FilterParam(state = as.character(c(1, 2, 5, 6))))

\S4method{segs}{HMMList}(object)

\S4method{hemizygous}{HMMList}(object)

\S4method{homozygous}{HMMList}(object)

\S4method{duplication}{HMMList}(object)

\S4method{cnvSegs}{HMMList}(object, filters = FilterParam(state = as.character(c(1, 2, 5, 6))))

\S4method{cnvFilter}{HMMList}(object, filters = FilterParam())

\S4method{cnvSegs}{HmmGRanges}(object, filters = FilterParam(state = as.character(c(1, 2, 5, 6))))
}
\arguments{
\item{object}{see \code{showMethods(cnvFilter)}}

\item{filters}{a \code{\link{FilterParam}} object}
}
\description{
The HMM-derived genomic ranges are represented as a
\code{GRanges}-derived object.  \code{cnvFilter} returns a
\code{GRanges} object using the filters stipulated in the
\code{filters} argument.
}
\examples{
data(snp_exp)
fit <- hmm2(snp_exp)
segs(fit) ## all intervals
cnvSegs(fit)
filter_param <- FilterParam(probability=0.95, numberFeatures=10, state=c("1", "2"))
cnvSegs(fit, filter_param)
filter_param <- FilterParam(probability=0.5, numberFeatures=2, state=c("1", "2"))
cnvSegs(fit, filter_param)
hemizygous(fit)
homozygous(fit)
duplication(fit)
}
\seealso{
\code{\link{FilterParam}}
}
