% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_custom_vcf_from_uniquorn.R
\name{remove_ccls_from_database}
\alias{remove_ccls_from_database}
\title{Remove Cancer Cell Line}
\usage{
remove_ccls_from_database(ccl_names, ref_gen = "GRCH37",
    library_name, test_mode = FALSE)
}
\arguments{
\item{ccl_names}{A character vector giving the names of the cancer cell line
identifiers to be removed. Can be one or many}

\item{ref_gen}{A character vector specifying the reference genome version.
All training sets are associated with a reference genome version. 
Default is \code{"GRCH37"}.}

\item{library_name}{Name of the library from which ccls are to be removed}

\item{test_mode}{Signifies if this is a test run}
}
\value{
Message that indicates whether the removal was succesful.
}
\description{
This function removes a cancer cell line training fingerprint (VCF file)
 from the database. The names of all training sets can 
 be seen by using the function \code{show_contained_cls}.
}
\examples{
remove_ccls_from_database(
    ccl_names = "HT29",
    ref_gen = "GRCH37",
    library_name = "CELLMINER",
    test_mode = TRUE
)
}
