% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ularcirc_plots.R
\name{plot_AllJunctions}
\alias{plot_AllJunctions}
\title{plot_AllJunctions}
\usage{
plot_AllJunctions(
  assembly = "hg38",
  chrom,
  chromstart,
  chromend,
  BSJData,
  BSJ_colors = "black",
  FSJData,
  FSJ_colors = "black",
  geneSymbol
)
}
\arguments{
\item{assembly}{: Genome assembly}

\item{chrom}{: chromosome}

\item{chromstart}{: Starting position of chromosome}

\item{chromend}{: End position of chromosome}

\item{BSJData}{: Backsplice junction data table}

\item{BSJ_colors}{: Backsplice junction assigned colours}

\item{FSJData}{: Forward junction data table}

\item{FSJ_colors}{: Forward junction assigned colours}

\item{geneSymbol}{: Gene symbol}
}
\value{
Returns a list of two DNAstring sets labelled "read1" and "read2" which correspond
to forward and reverse read pairs.
}
\description{
Plots a BSJ, FSJ and transcripts for a nominated gene. Output is combined 
onto a single page. This function effectively wraps plotting functions 
from plotgardener
}
\examples{

library('Ularcirc')
 # BSJ data.table
 BSJ_data <- data.table::data.table(chrom1="chr2", 
                start1=c(40139400, 40160764, 40428472, 40428472), 
                end1=c(40139400, 40160764,40428472, 40428472), 
                chrom2="chr2", start2=c(40178494,40178494,40430302,40430305),
                 end2=c(40178494,40178494,40430302,40430305),
               score=c(13,20,360,1751))

 # FSJ
 FSJstarts1 <- c(40115630,40139677,40160865,40164985,40170350,40174721,
                              40174843,40175282,40278771,40430302,40430305)
 FSJstarts2 <- c(40139400,40160764,40164853,40170280,40174705,40174824,
                               40175260,40178386,40428472,40453160,40512348)
 FSJ_data <- data.table::data.table(chrom1="chr2", start1=FSJstarts1, end1=FSJstarts1,
                     chrom2="chr2", start2=FSJstarts2, end2=FSJstarts2, 
                     score=c(225,825,685,666,633,596,517,542,685,101,171))
                     
 plot_AllJunctions(assembly="hg38", chrom="chr2", 
                     chromstart=40096769, chromend=40611554,
                     BSJData=BSJ_data, FSJData=FSJ_data, geneSymbol="SLC8A1") 

}
