% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{rankings2Uscore}
\alias{rankings2Uscore}
\title{Get signature scores from pre-computed rank matrix}
\usage{
rankings2Uscore(
  ranks_matrix,
  features,
  chunk.size = 100,
  w_neg = 1,
  BPPARAM = NULL,
  ncores = 1,
  force.gc = FALSE,
  missing_genes = c("impute", "skip"),
  name = "_UCell"
)
}
\arguments{
\item{ranks_matrix}{A rank matrix}

\item{features}{List of signatures}

\item{chunk.size}{How many cells per matrix chunk}

\item{w_neg}{Weight on negative signatures}

\item{BPPARAM}{A BioParallel object to instruct UCell how to
parallelize}

\item{ncores}{How many cores to use for parallelization?}

\item{force.gc}{Force garbage collection to recover RAM? (FALSE)}

\item{missing_genes}{How to handle missing genes in matrix:
"impute": impute expression to zero; "skip": remove missing
genes from signature}

\item{name}{Name suffix for metadata columns ("_UCell")}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{               A list of signature scores
}\if{html}{\out{</div>}}
}
\description{
Get signature scores from pre-computed rank matrix
}
