% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_showNode.R
\name{showNode}
\alias{showNode}
\title{Find nodes on the tree}
\usage{
showNode(tree, only.leaf = FALSE, use.alias = FALSE)
}
\arguments{
\item{tree}{A  phylo object.}

\item{only.leaf}{A logical value, TRUE or FALSE. The default is FALSE, all
nodes are output; otherwise, leaves are output}

\item{use.alias}{A logical value, TRUE or FALSE. The default is FALSE, and
the node label would be used to name the output; otherwise, the alias of
node label would be used to name the output. The alias of node label is
created by adding a prefix \code{"alias_"} to the node number.}
}
\value{
A vector of nodes. The numeric value is the node number, and the
  vector name is the corresponding node label. If a node has no label, it
  would have NA as name when \code{use.alias = FALSE}, and have the alias of
  node label as name when \code{use.alias = TRUE}.
}
\description{
\code{showNode} is to get nodes from the tree.
}
\examples{
library(ggtree)
data(tinyTree)

# PLOT tree
ggtree(tinyTree, branch.length = 'none') +
    geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7) +
    geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7)


## find the node shared by provided node labels
showNode(tree = tinyTree, only.leaf = TRUE,
          use.alias = FALSE)

showNode(tree = tinyTree, only.leaf = FALSE,
          use.alias = FALSE)
}
\author{
Ruizhu Huang
}
