% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowmean.R
\name{rowmean}
\alias{rowmean}
\alias{rowmedian}
\title{Compute column means based on a grouping variable}
\usage{
rowmean(x, group)

rowmedian(x, group)
}
\arguments{
\item{x}{A numeric matrix or matrix-like object.}

\item{group}{A vector or factor specifying the group assignment for each row of \code{x}.
Alternatively, a matrix of soft assignments for each row to each group (column).}
}
\value{
A numeric matrix with one row per level of \code{group},
where the value for each column contains the mean or median across the subset of rows corresponding that level.
}
\description{
Computes the column mean or median for each group of rows in a matrix.
}
\details{
The naming scheme here is somewhat inspired by the \code{\link{rowsum}} function. 
Admittedly, it is rather confusing when \code{\link{rowMeans}} computes the mean for a row across all columns
while \code{rowmean} computes the mean for a column across a subset of rows, but there you have it.

If \code{group} is a matrix, it is expected to contain soft assignment weights for each row in \code{x}.
Each row of \code{group} should contain non-negative values that sum to unity.
These are used to compute weighted means or medians via \pkg{MatrixGenerics} functions.
}
\examples{
x <- matrix(runif(100), ncol = 5)
group <- sample(1:8, 20, TRUE)
(xmean <- rowmean(x, group))
(xmeds <- rowmedian(x, group))

}
\author{
Aaron Lun
}
