% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{pathToSphericalData}
\alias{pathToSphericalData}
\title{Find the spherical data for a given path}
\usage{
pathToSphericalData(path, from, to, d, statistic)
}
\arguments{
\item{path}{- This is an mxn dimensional matrix. Each row is
considered a point.}

\item{from}{- The starting place along the path which will be
treated as the center of the sphere.  This defaults to 1.}

\item{to}{- The end point of the path.  This defaults to
nrow(path).}

\item{d}{- The dimension under consideration.  This defaults to
ncol(path)}

\item{statistic}{- One of 'median', 'mean' or 'max'}
}
\value{
This function returns a list whose elements are the
    projections of the path to the sphere, the center for those
    projections, the median, mean or max distance from the center
    to those projections and the name of the statistic used.
}
\description{
This function takes a path and returns a list containing
its projection to the sphere, the center for that projection,
the spherical distance from the center to the points of the
projection and the name of the statistic used.
}
\examples{
sphericalData = pathToSphericalData(straight_path,from=1,
                                    to=nrow(straight_path), d=3,
                                    statistic='median')
}
