% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{saveTnT}
\alias{saveTnT}
\title{Save a TnTBoard to an HTML file}
\usage{
saveTnT(
  tntdef,
  file,
  selfcontained = TRUE,
  libdir = NULL,
  background = "white",
  knitrOptions = list()
)
}
\arguments{
\item{tntdef}{A TnTBoard/TnTGenome object to save.}

\item{file, selfcontained, libdir, background, knitrOptions}{Passed to \code{\link[htmlwidgets]{saveWidget}}.}
}
\value{
Return NULL.
}
\description{
A simple wrapper of \code{\link[htmlwidgets]{saveWidget}}, which saves a
TnTBoard/TnTGenome object to an HTML file (e.g. for sharing with others).
}
\examples{
data <- GRanges("chr2", IRanges(c(6,9,42), width = 1),
                value = c(0.3, 0.5, 0.9))
track <- PinTrack(data, label = NULL, background = "green")
genome <- TnTGenome(list(track))
destfile <- tempfile(fileext = ".html")
destfile
saveTnT(genome, destfile)
\dontrun{
utils::browseURL(destfile)
}
}
