% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R
\name{createPPlotScores}
\alias{createPPlotScores}
\title{Evaluate assumptions of the Target Decoys Approach for multiple search
engines}
\usage{
createPPlotScores(object, scores, decoy, log10 = TRUE)
}
\arguments{
\item{object}{A \code{data.frame}, \linkS4class{mzID} or \linkS4class{mzRident} object.}

\item{scores}{A \code{character} vector of multiple score names from the input
object. Typically from different search engines.}

\item{decoy}{\code{character}, name of the variable that indicates if the peptide
matches to a target or to a decoy. When this value is missing, a Shiny
gadget is launched to select it interactively.}

\item{log10}{\code{logical} to indicate if the score should be
\code{-log10}-transformed. Default: \code{TRUE}. When this value is missing, a Shiny
gadget is launched to select it interactively.}
}
\value{
One PP plot with all original pi0, and a standardized / rescaled PP plot with
all \code{pi0} set to 0.
}
\description{
Create diagnostic PP plots in one figure to evaluate the TDA assumptions for
multiple search engines. The function provides the possibility to evaluate
each of the sub-engines and the overall itself.
}
\examples{
library(mzID)

## Use one of the example files in the mzID package
exampleFile <- system.file("extdata", "55merge_tandem.mzid", package = "mzID")
mzIDexample <- mzID(exampleFile)

plots <- createPPlotScores(mzIDexample,
    scores = c("x\\\\!tandem:hyperscore", "x\\\\!tandem:expect"),
    decoy = "isdecoy", log10 = TRUE
)
}
\author{
Elke Debrie, Lieven Clement
}
