% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{model_gam}
\alias{model_gam}
\title{Generalized Addidtive Modeling on TSA data}
\usage{
model_gam(norm_data, x, y)
}
\arguments{
\item{norm_data}{data frame input of only one well's reading, preferably
normalized using \code{\link{normalize}}.}

\item{x}{temperature column}

\item{y}{normalized fluorescence column}
}
\value{
data frame containing gam model fitted values
}
\description{
Function finds fitted fluorescence values by imposing generalized
    additive model on fluorescence data by temperature. Model assumes
    method = "GACV.Cp" and sets to \code{formula = y ~ s(x, bs = "ad")}.
    Function inherits function from gam package, \code{\link{gam}}().
}
\examples{
data("qPCR_data1")
test <- subset(qPCR_data1, Well.Position == "A01")
test <- normalize(test, fluo = 5, selected = c(
    "Well.Position", "Temperature",
    "Fluorescence", "Normalized"
))
model_gam(test, x = test$Temperature, y = test$Normalized)

}
\seealso{
Other data_preprocess: 
\code{\link{model_boltzmann}()},
\code{\link{model_fit}()},
\code{\link{normalize}()},
\code{\link{remove_raw}()},
\code{\link{run_boltzmann}()},
\code{\link{screen}()},
\code{\link{view_model}()},
\code{\link{weed_raw}()}
}
\concept{data_preprocess}
