% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tronco.plot.R
\name{tronco.plot}
\alias{tronco.plot}
\title{tronco.plot}
\usage{
tronco.plot(
  x,
  models = names(x$model),
  fontsize = NA,
  height = 2,
  width = 3,
  height.logic = 1,
  pf = FALSE,
  disconnected = FALSE,
  scale.nodes = NA,
  title = as.description(x),
  confidence = NA,
  p.min = 0.05,
  legend = TRUE,
  legend.cex = 1,
  edge.cex = 1,
  label.edge.size = NA,
  expand = TRUE,
  genes = NULL,
  relations.filter = NA,
  edge.color = "black",
  pathways.color = "Set1",
  file = NA,
  legend.pos = "bottom",
  pathways = NULL,
  lwd = 3,
  samples.annotation = NA,
  export.igraph = FALSE,
  create.new.dev = TRUE,
  ...
)
}
\arguments{
\item{x}{A reconstructed model (the output of the inference
by a tronco function)}

\item{models}{A vector containing the names of the
algorithms used (caprese, capri_bic, etc)}

\item{fontsize}{For node names. Default NA for
automatic rescaling}

\item{height}{Proportion node height - node width.
Default height 2}

\item{width}{Proportion node height - node width.
Default width 2}

\item{height.logic}{Height of logical nodes.
Defaul 1}

\item{pf}{Should I print Prima Facie?
Default False}

\item{disconnected}{Should I print disconnected
nodes? Default False}

\item{scale.nodes}{Node scaling coefficient
(based on node frequency). Default NA (autoscale)}

\item{title}{Title of the plot. Default as.description(x)}

\item{confidence}{Should I add confidence
informations? No if NA}

\item{p.min}{p-value cutoff. Default automatic}

\item{legend}{Should I visualise the legend?}

\item{legend.cex}{CEX value for legend. Default 1.0}

\item{edge.cex}{CEX value for edge labels. Default 1.0}

\item{label.edge.size}{Size of edge labels.
Default NA for automatic rescaling}

\item{expand}{Should I expand hypotheses? Default TRUE}

\item{genes}{Visualise only genes in this list.
Default NULL, visualise all.}

\item{relations.filter}{Filter relations to dispaly
according to this functions. Default NA}

\item{edge.color}{Edge color. Default 'black'}

\item{pathways.color}{RColorBrewer colorser
for patways. Default 'Set1'.}

\item{file}{String containing filename for PDF output.
If NA no PDF output will be provided}

\item{legend.pos}{Legend position. Default 'bottom',}

\item{pathways}{A vector containing pathways information
as described in as.patterns()}

\item{lwd}{Edge base lwd. Default 3}

\item{samples.annotation}{= List of samples to search
for events in model}

\item{export.igraph}{If TRUE export the generated igraph
object}

\item{create.new.dev}{If TRUE create a new graphical device 
when calling trono.plot. Set this to FALSE, e.g., if you do not 
wish to create a new device when executing the command with 
export.igraph = TRUE}

\item{...}{Additional arguments for RGraphviz
plot function}
}
\value{
Information about the reconstructed model
}
\description{
Plots a progression model from a recostructed dataset. For details and examples
regarding the visualization of an inferred model,
we refer to the Vignette Section 7.
}
\examples{
data(test_model)
tronco.plot(test_model)

}
