% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.kfold.prederr}
\alias{as.kfold.prederr}
\title{as.kfold.prederr}
\usage{
as.kfold.prederr(
  x,
  events = as.events(x),
  models = names(x$model),
  values = FALSE,
  table = FALSE
)
}
\arguments{
\item{x}{A TRONCO model.}

\item{events}{A subset of events as of \code{as.events(x)}, all by default.}

\item{models}{A subset of reconstructed models, all by default.}

\item{values}{If you want to see also the values}

\item{table}{Keep the original table (defaul false)}
}
\value{
All the bootstrap scores in a TRONCO model
}
\description{
Returns a dataframe with all the prediction error score in a 
TRONCO model. It is possible to specify a subset of events
or models if multiple reconstruction have been performed.
}
\examples{
data(test_model_kfold)
as.kfold.prederr(test_model_kfold)
as.kfold.prederr(test_model_kfold, models='capri_aic')

}
