% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_cells.R
\name{rank_cells}
\alias{rank_cells}
\title{Get the Rank of the Expression for each Gene in each Cell}
\usage{
rank_cells(sce, group_col = "cellType", assay = "logcounts")
}
\arguments{
\item{sce}{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class} object with
the \code{assay} (defaults to \code{logcounts}).}

\item{group_col}{name of the column in the
\link[SummarizedExperiment:SummarizedExperiment-class]{colData()} of \code{sce}
that defines the group of interest.}

\item{assay}{A \code{character(1)} specifying the name of the
\link[SummarizedExperiment:SummarizedExperiment-class]{assay()} in the
\code{sce} object to use to rank expression values. Defaults to \code{logcounts} since
it typically contains the normalized expression values.}
}
\value{
A named \code{list()} of \code{matrix()} objects. Each \code{matrix()} contains the
rank values for the cells belonging to one group.
}
\description{
This function finds the rank of each gene's expression for each cell,
grouped by the user defined variable. This data is used to compute the rank
invariance value for each gene later with \code{rank_invariance()}.
}
\examples{
## Rank the genes for each cell, organized by "group" column
rank_cells(sce_zero_test, group_col = "group")
}
\seealso{
Other invariance functions: 
\code{\link{rank_group}()},
\code{\link{rank_invariance_express}()},
\code{\link{rank_invariance}()}
}
\concept{invariance functions}
