% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_prop_zero.R
\name{filter_prop_zero}
\alias{filter_prop_zero}
\title{Filter Genes for by Max Proportion Zero Among Groups}
\usage{
filter_prop_zero(prop_zero_df, cutoff = 0.9, na.rm = TRUE)
}
\arguments{
\item{prop_zero_df}{\code{data.frame()} containing proportion of zero counts, genes as
rows, groups as columns.}

\item{cutoff}{A \code{numeric()} cutoff value for maximum Proportion Zero.
The cutoff value should be < 1.}

\item{na.rm}{a logical indicating whether missing values should be removed
when max prop_zero is calculated.}
}
\value{
A \code{character()} of gene names that are under the cutoff.
These names are from the \code{rownames()} of the expression data.
}
\description{
This function uses the \code{data.frame()} generated to find the maximum Proportion
Zero across groups, then filter to a set of genes that pass the max Prop Zero
cutoff defined by the user.
}
\examples{
## Get Proportion Zero data.frame
prop_zero <- get_prop_zero(sce_zero_test, group_col = "group")

## Filter with max Proportion Zero cutoff = 0.59
filter_prop_zero(prop_zero, cutoff = 0.59)

## NA handling
prop_zero[1, 1] <- NA

## If NA are present in the prop_zero_df the user can choose to:

## Remove NAs (default)
## genes with NA counts may be included in the final list
filter_prop_zero(prop_zero, cutoff = 0.59, na.rm = TRUE)

## Include NA values
## any gene with genes with NA counts (so max prop_zero will be NA)
## will be removed from the final list, this will throw warning
filter_prop_zero(prop_zero, cutoff = 0.59, na.rm = FALSE)

}
\seealso{
Other Proportion Zero functions: 
\code{\link{get_prop_zero}()}
}
\concept{Proportion Zero functions}
