% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeTPPTR.R
\name{analyzeTPPTR}
\alias{analyzeTPPTR}
\title{Analyze TPP-TR experiment}
\usage{
analyzeTPPTR(
  configTable,
  data = NULL,
  resultPath = NULL,
  methods = c("meltcurvefit", "splinefit"),
  idVar = "gene_name",
  fcStr = "rel_fc_",
  ciStr = NULL,
  naStrs = c("NA", "n/d", "NaN", "<NA>"),
  qualColName = "qupm",
  normalize = TRUE,
  normReqs = tpptrDefaultNormReqs(),
  ggplotTheme = tppDefaultTheme(),
  nCores = "max",
  startPars = c(Pl = 0, a = 550, b = 10),
  splineDF = c(3:7),
  maxAttempts = 500,
  plotCurves = TRUE,
  fixedReference = NULL,
  pValMethod = "robustZ",
  pValFilter = list(minR2 = 0.8, maxPlateau = 0.3),
  pValParams = list(binWidth = 300),
  verbose = FALSE,
  xlsxExport = TRUE
)
}
\arguments{
\item{configTable}{dataframe, or character object with the path to a file, 
that specifies important details of the TPP-TR experiment. See Section 
\code{details} for instructions how to create this object.}

\item{data}{single dataframe, or list of dataframes, containing fold change 
measurements and additional annotation columns to be imported. Can be used 
instead of specifying the file path in the \code{configTable} argument.}

\item{resultPath}{location where to store melting curve plots, intermediate 
results, and the final results table.}

\item{methods}{statistical methods for modeling melting behavior and detecting 
significant differences between experimental conditions. Ich more than one 
method are specified, results will be computed for each and concatenated in 
the result table (default: meltcurvefit).}

\item{idVar}{character string indicating which data column provides the 
unique identifiers for each protein.}

\item{fcStr}{character string indicating which columns contain the actual 
fold change values. Those column names containing the suffix \code{fcStr} 
will be regarded as containing fold change values.}

\item{ciStr}{character string indicating which columns contain confidence 
intervals for the fold change measurements. If specified, confidence 
intervals will be plotted around the melting curves.}

\item{naStrs}{character vector indicating missing values in the data table. 
When reading data from file, this value will be passed on to the argument 
\code{na.strings} in function \code{read.delim}.}

\item{qualColName}{character string indicating which column can be used for 
additional quality criteria when deciding between different non-unique 
protein identifiers.}

\item{normalize}{perform normalization (default: TRUE).}

\item{normReqs}{list of filtering criteria for construction of the 
normalization set.}

\item{ggplotTheme}{ggplot theme for melting curve plots.}

\item{nCores}{either a numerical value given the desired number of CPUs, or 
'max' to automatically assign the maximum possible number (default).}

\item{startPars}{start values for the melting curve parameters. Will be 
passed to function \code{\link{nls}} for curve fitting.}

\item{splineDF}{degrees of freedom for natural spline fitting.}

\item{maxAttempts}{maximal number of curve fitting attempts if model does not
converge.}

\item{plotCurves}{boolean value indicating whether melting curves should be 
plotted. Deactivating plotting decreases runtime.}

\item{fixedReference}{name of a fixed reference experiment for normalization. 
If NULL (default), the experiment with the best R2 when fitting a melting 
curve through the median fold changes is chosen as the reference.}

\item{pValMethod}{Method for p-value computation. Currently restricted to 
'robustZ' (see Cox & Mann (2008)).}

\item{pValFilter}{optional list of filtering criteria to be applied before 
p-value computation.}

\item{pValParams}{optional list of parameters for p-value computation.}

\item{verbose}{print name of each fitted protein to the command lin as a
means of progress report.}

\item{xlsxExport}{boolean value indicating whether to produce result table in
.xlsx format (requires package \code{openxlsx} and a zip application to be 
installed).}
}
\value{
A data frame in which the fit results are stored row-wise for each 
  protein.
}
\description{
Performs analysis of a TPP-TR experiment by invoking routines 
  for data import, data processing, normalization, curve fitting, and 
  production of the result table.
}
\details{
Invokes the following steps: \enumerate{ \item Import data using the
  \code{\link{tpptrImport}} function. \item Perform normalization (optional)
  using the \code{\link{tpptrNormalize}} function. To perform normalization, 
  set argument \code{normalize=TRUE}. The normalization will be filtered 
  according to the criteria specified in the \code{normReqs} argument (also 
  see the documentation of \code{\link{tpptrNormalize}} and 
  \code{\link{tpptrDefaultNormReqs}} for further information). \item Fit
  melting curves using the function \code{\link{tpptrCurveFit}}. \item
  Produce result table using the function \code{\link{tpptrAnalyzeMeltingCurves}}. 
  \item Export results to Excel using the function \code{\link{tppExport}}. }
  
  The default settings are tailored towards the output of the python package 
  isobarQuant, but can be customized to your own dataset by the arguments 
  \code{idVar, fcStr, naStrs, qualColName}.
  
  If \code{resultPath} is not specified, the location of the first input file
  specified in \code{configTable} will be used. If the input data are not 
  specified in \code{configTable}, no result path will be set. This means 
  that no output files or melting curve plots are produced and 
  \code{analyzeTPPTR} just returns the results as a data frame.
  
  The function \code{analyzeTPPTR} reports intermediate results to the 
  command line. To suppress this, use \code{\link{suppressMessages}}.
  
  The \code{configTable} argument is a dataframe, or the path to a 
  spreadsheet (tab-delimited text-file or xlsx format). Information about 
  each experiment is stored row-wise. It contains the following columns: 
  \itemize{ \item{\code{Path}:}{location of each datafile. Alternatively, 
  data can be directly handed over by the \code{data} argument.} 
  \item{\code{Experiment}: }{unique experiment names.} 
  \item{\code{Condition}: }{experimental conditions of each dataset.} 
  \item{Label columns: } each isobaric label names a column that contains the
  temperatures administered for the label in the individual experiments. }
  
  The argument \code{methods} can be one of the following:
  More than one method can be specified. For example, parametric testing of 
  melting points and nonparametric spline-based goodness-of-fit tests can be 
  performed sequentially in the same analysis. The results are then written 
  to separate columns of the output table.
  
  If \code{methods} contains "meltcurvefit", melting curve plots will be 
  stored in a subfolder with name \code{Melting_Curves} at the location 
  specified by \code{resultPath}.
  If \code{methods} contains "splinefit", plots of the natural spline fits will be 
  stored in a subfolder with name \code{Spline_Fits} at the location 
  specified by \code{resultPath}.
  
  The argument \code{nCores} could be either 'max' (use all available cores) 
  or an upper limit of CPUs to be used.
  
  If \code{doPlot = TRUE}, melting curve plots are generated separately for 
  each protein and stored in separate pdfs.
  Each file is named by the unique protein identifier. Filenames are
  truncated to 255 characters (requirement by most operation systems). 
  Truncated filenames are indicated by the suffix "_truncated[d]", where [d] 
  is a unique number to avoid redundancies.
  All melting curve plots are stored in a subfolder with name 
  \code{Melting_Curves} at the location specified by \code{resultPath}.
  
  If the melting curve fitting procedure does not converge, it will be 
  repeatedly started from perturbed starting parameters (maximum iterations 
  defined by argument \code{maxAttempts}).
  
  Argument \code{splineDF} specifies the degrees of freedom for natural
  spline fitting. As a single numeric value, it is directly passed on to the
  \code{splineDF} argument of \code{splines::ns}. Experience shows that
  \code{splineDF = 4} yields good results for TPP data sets with 10
  temperature points. It is also possible to provide a numeric vector. In
  this case, splines are fitted for each entry and the optimal value is
  chosen per protein using Akaike's Information criterion.
}
\examples{
data(hdacTR_smallExample)
tpptrResults <- analyzeTPPTR(configTable = hdacTR_config, data = hdacTR_data, 
                methods = "meltcurvefit", nCores = 1)

}
\references{
Savitski, M. M., Reinhard, F. B., Franken, H., Werner, T., 
  Savitski, M. F., Eberhard, D., ... & Drewes, G. (2014). Tracking cancer 
  drugs in living cells by thermal profiling of the proteome. Science, 
  346(6205), 1255784.
  
  Franken, H, Mathieson, T, Childs, D. Sweetman, G. Werner, T. Huber, W. & Savitski, M. M. (2015),
  Thermal proteome profiling for unbiased identification of drug targets and detection of downstream effectors.
  Nature protocols 10(10), 1567-1593.
}
\seealso{
tppDefaultTheme, tpptrImport, tpptrNormalize, tpptrCurveFit, 
tpptrAnalyzeMeltingCurves
}
