% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOP_survival.R
\name{TOP_survivalPrediction}
\alias{TOP_survivalPrediction}
\title{TOP_survivalPrediction}
\usage{
TOP_survivalPrediction(TOP_survival, newx)
}
\arguments{
\item{TOP_survival}{A TOP_survival model. See \code{\link{TOP_survival}}.}

\item{newx}{A new dataset to predict the survival time.}
}
\value{
A vector of predicted survival time.
}
\description{
A prediction function for TOP_survival
}
\examples{
data(TOP_data_binary, package = "TOP")
time <- rpois(300, c(600, 1000))
surv <- sample(c(0, 1), 300, replace = TRUE)
y <- data.frame(time, surv)

batch <- rep(paste0("y", 1:3), c(100, 100, 100))
y_list <- y |> split(batch)

x_list <- list(TOP_data_binary$x1, TOP_data_binary$x2, TOP_data_binary$x3)

surv_model <- TOP_survival(x_list[-3], y_list[-3], nFeatures = 10)
TOP_survivalPrediction(surv_model, newx = x_list[[3]])
}
