% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{TOP_lambdaPlot}
\alias{TOP_lambdaPlot}
\title{TOP_lambdaPlot}
\usage{
TOP_lambdaPlot(
  TOP_model,
  nFeatures = 20,
  s = "lambda.min",
  interactive = FALSE,
  label = FALSE
)
}
\arguments{
\item{TOP_model}{A Transferable Omics Prediction model. The output from the
TOP_model function.}

\item{nFeatures}{The number of features to plot, features are ranked beta's
for lambda.min. Default: 20}

\item{s}{Lambda value for the lasso model. Default is "lambda.min"}

\item{interactive}{A boolean indicaitng whether the plot should be
interactive. Defaults to FALSE .}

\item{label}{A boolean indicating whether the features should be labeled on
the plot. Defaults to FALSE .}
}
\value{
A TOP lambda plot
}
\description{
TOP_lambdaPlot
}
\examples{
data(TOP_data_binary, package = "TOP")

x1 <- TOP_data_binary$x1
x2 <- TOP_data_binary$x2
x3 <- TOP_data_binary$x3
y1 <- TOP_data_binary$y1
y2 <- TOP_data_binary$y2
y3 <- TOP_data_binary$y3

set.seed(23)
x_list <- list(x1, x2)
y_list <- list(factor(y1), factor(y2))

model <- TOP_model(x_list, y_list)
TOP_lambdaPlot(model)

}
