% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxFile-class.R
\name{TENxFile}
\alias{TENxFile}
\title{TENxFile constructor function}
\usage{
TENxFile(resource, extension, ...)
}
\arguments{
\item{resource}{character(1) The path to the file}

\item{extension}{character(1) The file extension for the given resource. It
can usually be obtained from the file path. An override can be provided
especially for \code{ExperimentHub} resources where the file extension is
removed.}

\item{...}{Additional inputs to the low level class generator functions}
}
\value{
A subclass of \code{TENxFile} according to the input file extension
}
\description{
The \code{TENxFile} constructor function serves as the
auto-recognizer function for 10X files. It can import several different
file extensions, namely:
\preformatted{
    * H5 - on-disk HDF5
    * MTX - matrix market
    * .tar.gz - compressed tarball
}
}
\details{
\strong{Note} that the example below includes the use of a large ~ 4 GB
\code{ExperimentHub} resource obtained from the 10X website.
}
\examples{
if (interactive()) {

    ## from ExperimentHub
    hub <- ExperimentHub::ExperimentHub()
    fname <- hub[["EH1039"]]
    TENxFile(fname, extension = "h5", group = "mm10", version = "2")
    TENxFile(fname, extension = "h5", group = "mm10", version = "2") |>
        metadata()

}
}
