% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEgeneTE.R
\name{DEgeneTE}
\alias{DEgeneTE}
\title{Estimate differentially expressed genes and TEs}
\usage{
DEgeneTE(geneTable, teTable, metadata, expDesign=TRUE, fileDir=NULL)
}
\arguments{
\item{geneTable}{gene input table from using DECorrInputs()}

\item{teTable}{TE input table from using DECorrInputs()}

\item{metadata}{an one column dataframe with rownames same as the column 
name of gene/te count table. Column name must be \strong{species} 
or \strong{experiment}.}

\item{expDesign}{Logic value for comparing between or within species. 
\strong{TRUE} for comparing between two species, and \strong{FALSE} 
for comparing between control and treatment.}

\item{fileDir}{the name and path of directory for saving output files. 
Default is NULL.}
}
\value{
return DESeq2 res and normalized gene counts.
}
\description{
To estimate differentially expressed genes and TEs, 
DEgeneTE() takes
gene inputs and TE inputs from the results using the DECorrInputs function. 
You need to specify your metadata and expDesign based on your design. If 
you also want to save the output, please specify the fileDir parameter.
}
\examples{
## comparing between species: 
## (1) set expDesign = TRUE 
## (2) column name of metadata needs to be "species".

data(fetchDataHmChimp)
fetchData <- fetchDataHmChimp

inputBundle <- DECorrInputs(fetchData)

meta <- data.frame(species=c(rep("human", ncol(fetchData$geneRef) - 1), 
    rep("chimpanzee", ncol(fetchData$geneCompare) - 1))
)
rownames(meta) <- colnames(inputBundle$geneInputDESeq2)
meta$species <- factor(meta$species, levels = c("human", "chimpanzee"))

hmchimpDE <- DEgeneTE(
    geneTable = inputBundle$geneInputDESeq2,
    teTable = inputBundle$teInputDESeq2,
    metadata = meta,
    expDesign = TRUE
)
}
