% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DECorrInputs.R
\name{DECorrInputs}
\alias{DECorrInputs}
\title{Generate all the input files for TEKRABber downstream analysis}
\usage{
DECorrInputs(fetchData)
}
\arguments{
\item{fetchData}{output list from TEKRABber::orthologScale()}
}
\value{
create inputs for DE analysis and correlations: 
(1) geneInputDESeq2 (2) teInputDESeq2 (3) geneCorrInputRef 
(4) geneCorrInputCompare (5) TECorrInputRef (6) TECorrInputCompare
}
\description{
Generate all the inputs files for differentially expressed 
orthologous genes/TEs analysis, and for correlation analysis. The output 
is a list containing 6 dataframes.
}
\examples{
data(speciesCounts)
data(hg38_panTro6_rmsk)
hmGene <- speciesCounts$hmGene
chimpGene <- speciesCounts$chimpGene
hmTE <- speciesCounts$hmTE
chimpTE <- speciesCounts$chimpTE

## For demonstration, here we only select 1000 rows to save time
set.seed(1234)
hmGeneSample <- hmGene[sample(nrow(hmGene), 1000), ]
chimpGeneSample <- chimpGene[sample(nrow(chimpGene), 1000), ]

fetchData <- orthologScale(
    speciesRef = "hsapiens",
    speciesCompare = "ptroglodytes",
    geneCountRef = hmGeneSample,
    geneCountCompare = chimpGeneSample,
    teCountRef = hmTE,
    teCountCompare = chimpTE,
    rmsk = hg38_panTro6_rmsk,
    version = 105
)

inputBundle <- DECorrInputs(fetchData)
}
