% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectSingularValueVectorLarge.R
\name{selectSingularValueVectorLarge}
\alias{selectSingularValueVectorLarge}
\title{Title
Select singular value vectors from HOSVD (boxplot version)}
\usage{
selectSingularValueVectorLarge(HOSVD, cond, input_all = NULL)
}
\arguments{
\item{HOSVD}{output from HOSVD}

\item{cond}{Labels to select singular value vector number}

\item{input_all}{if list is not null, no interactive mode is
activated but provided values are used.}
}
\value{
Selected singular value vector IDs
}
\description{
Title
Select singular value vectors from HOSVD (boxplot version)
}
\examples{
Z <- PrepareSummarizedExperimentTensor(
sample=matrix(as.character(seq_len(6)),c(3,2)),
feature=as.character(seq_len(10)),
 value=array(runif(10*3*2),c(10,3,2)))
HOSVD <- computeHosvd(Z)
 cond <- list(0,c("A","B","C"),c("A","B"))
 input_all <- selectSingularValueVectorLarge(HOSVD,cond,input_all=c(1,1))
}
