% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OriginalModel.R
\name{subsetGeneSet}
\alias{subsetGeneSet}
\title{Filter gene expression value matrix based on certain gene sets.}
\usage{
subsetGeneSet(
  theObject,
  gene_set,
  useAssay,
  obtainDiagnosis = FALSE,
  annotationColName = NULL
)
}
\arguments{
\item{theObject}{A SummarizedExperiment object that has been pre-stored in
OriginalTrainingData.RDA}

\item{gene_set}{A character vector that includes gene symbols for gene signatures.}

\item{useAssay}{A character string or an integer specifying the assay in the \code{theObject}
that will be selected.}

\item{obtainDiagnosis}{Boolean. Usually used to create training data if TRUE. Default is FALSE}

\item{annotationColName}{A character string specifying the column name of disease status.
Only used when creating training data. Default is NULL.}
}
\value{
A \code{matrix} with selected gene expression value if \code{obtainDiagnosis == FALSE}.
If \code{obtainDiagnosis == TRUE}, return a \code{list} contains the selected
gene expression value and diagnosis results for each sample.
}
\description{
A function used to subset gene expression value matrix based on certain gene sets.
}
