% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_primers.R
\name{exportPrimers}
\alias{exportPrimers}
\alias{createPrimerTrack}
\alias{createPrimerTrack,TsIO-method}
\alias{createPrimerTrack,TsIOList-method}
\alias{exportPrimerTrack}
\alias{primerDataFrame}
\alias{primerDataFrame,TsIO-method}
\alias{primerDataFrame,TsIOList-method}
\title{Export TAP-seq primers}
\usage{
createPrimerTrack(object, color = 1)

\S4method{createPrimerTrack}{TsIO}(object, color = 1)

\S4method{createPrimerTrack}{TsIOList}(object, color = 1)

exportPrimerTrack(..., con)

primerDataFrame(object)

\S4method{primerDataFrame}{TsIO}(object)

\S4method{primerDataFrame}{TsIOList}(object)
}
\arguments{
\item{object}{A \code{\link[TAPseq:TsIO-class]{TsIO}} or
\code{\link[TAPseq:TsIOList-class]{TsIOList}} object containing designed primers.}

\item{color}{Color used for the track (Default: black). Can be any of the three kinds of R color
specifications.}

\item{...}{One or more primer BED tracks created by
\code{\link[TAPseq:exportPrimers]{createPrimerTrack}}.}

\item{con}{Connection to which tracks are written. Typically a .bed file.}
}
\value{
For \code{createPrimerTrack} a \code{\link[base]{data.frame}} with the primer track in
  BED format.
}
\description{
A set of functions for TAP-seq primer export. Convert primers stored in
\code{\link[TAPseq:TsIO-class]{TsIO}} or \code{\link[TAPseq:TsIOList-class]{TsIOList}} objects to
a simple \code{\link[base]{data.frame}} for easier export. Or create BED format tracks for
primers and write them to files for viewing in a genome browser (e.g. IGV).
}
\section{Functions}{
\itemize{
\item \code{createPrimerTrack(TsIO)}: Create primer BED track from \code{TsIO} objects

\item \code{createPrimerTrack(TsIOList)}: Create primer BED track from \code{TsIOList} objects

\item \code{exportPrimerTrack()}: Export primer BED tracks files

\item \code{primerDataFrame(TsIO)}: Create a \code{data.frame} with primer data from \code{TsIO}

\item \code{primerDataFrame(TsIOList)}: Create a \code{data.frame} with primer data from \code{TsIOList}

}}
\examples{
# chr11 primers example data
data("chr11_primers")

# pick best primers based on predicted off-targets
best_primers <- pickPrimers(chr11_primers, n = 1, by = "off_targets")

# primers data can be exported to a simple data.frame to e.g. write them to a .csv file
primers_df <- primerDataFrame(best_primers)
head(primers_df)


# primer binding sites in transcript sequences can be converted to genomic coordinates to create
# a BED track to visualize primers in a genome browser (e.g. IGV)

# create primer BED track with a fancy color
track <- createPrimerTrack(best_primers[1:5], color = "steelblue3")

# tracks can be written to .bed files using a little helper function (replace con = "" by a file)
exportPrimerTrack(track, con = "")

\dontrun{
# one can easily export primer tracks for multiple TsIO or TsIOList objects (e.g. inner and
# outer nested primers) to one .bed file using different colors for each object. see vignette for
# a practical example:
vignette("tapseq_primer_design", package = "TAPseq")

obj1 <- best_primers[1:5]
obj2 <- best_primers[6:10]
exportPrimerTrack(createPrimerTrack(obj1, color = "steelblue3"),
                  createPrimerTrack(obj2, color = "goldenrod1"),
                  con = "path/to/file.bed")

}
}
