% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simCytoData.R
\name{simCytoData}
\alias{simCytoData}
\title{Simulate cytometry data}
\usage{
simCytoData(nmarkers = 10, ncells = rep(10000, 2))
}
\arguments{
\item{nmarkers}{A numeric value specifying number of markers to simulate.}

\item{ncells}{A numeric vector specifying the number of cells to simulate
per sample.
1 vector element per sample.}
}
\value{
A \pkg{data.table} object containing the simulated cytometry data where rows
represent cells and columns represent markers.
}
\description{
Simulate some cytometry data for use in testing or documenting functions
which require some cytometry data.
Please run \code{set.seed} before running the function if you want to ensure
reproducibility.
}
\examples{
set.seed(42)
cyto_dat <- simCytoData()
head(cyto_dat)
dim(cyto_dat)

}
\author{
Givanna Putri
}
