% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svmExternalData.R
\name{svmExternalData}
\alias{svmExternalData}
\title{Peptide/exon/transcript centric or
PTM enriched classification}
\usage{
svmExternalData(df, modelA, modelB)
}
\arguments{
\item{df, }{data frame fractionated additional data}

\item{modelA, }{model for the replicate A classification}

\item{modelB, }{model for the replicate B classification}
}
\value{
c.cls.df
}
\description{
Peptide/exon/transcript centric or
PTM enriched classification is applied to predict
localization of them.
}
\examples{
{

df <- loadData(SubCellBarCode::hcc827Ctrl)

c.prots <- calculateCoveredProtein(rownames(df), markerProteins[,1])

set.seed(7)
c.prots <- sample(c.prots, 550)
cls <- svmClassification(c.prots, df, markerProteins)
modelA <- cls[[1]]$model
modelB <- cls[[2]]$model

exon.cls <- svmExternalData(SubCellBarCode::hcc827exon,
modelA = modelA, modelB = modelB)
}
}
