\name{DAGTeam}
\Rdversion{1.1}
\docType{class}
\alias{DAGTeam-class}
\alias{DAGParam-class}
% *Team-methods
\alias{DAGTeam}
\alias{DAGParam}
\alias{DAGParam,missing-method}
\alias{DAGParam,graphNEL-method}
\alias{DAGParam,matrix-method}
\alias{DAGParam,data.frame-method}
\alias{plot.DAGParam}
\alias{plot.DAGTeam}

\title{Consumer classes for directed acyclic graph evaluation}

\description{

  A \code{\linkS4class{Consumer}} to route incoming tasks through nodes
  connected as a directed acyclic graph.

}

\usage{
DAGParam(x, ...)

DAGTeam(..., dagParam = DAGParam(), teamParam = MulticoreParam(1L))

\S3method{plot}{DAGTeam}(x, y, ...)
}

\arguments{

  \item{x}{A matrix or data.frame with columns \sQuote{From},
    \sQuote{To}, or a \code{graphNEL} object (from the graph package)
    describing a directed acyclic graph.}

  \item{...}{For \code{DAGTeam}, named \code{\link{FunctionConsumer}}
    instances, one for each node in the graph. The
    \code{FunctionConsumer} corresponding to the first node in the graph
    must accept one argument; remaining \code{FunctionConsumer}
    instances must have as input arguments the names of the nodes from
    which the inputs derive, as in the example below.

    For \code{DAGParam} when \code{x} is a data.frame or matrix,
    data.frame columns \code{W}, \code{V} or additional arguments
    \code{W}, \code{V} as described in \code{\link{ftM2graphNEL}}.

  }

  \item{dagParam}{A \code{DAGParam} instance, with all nodes referenced
    in the graph represented by \code{\link{FunctionConsumer}} instances
    in \code{...}.}

  \item{teamParam}{A \code{ParallelParam} instance, such as generated by
    \code{MulticoreParam()}. Currently ignored (all calculations are
    performed on a single thread).}

  \item{y}{Unused.}

}

\section{Constructors}{

  Use \code{DAGParam} and \code{DAGTeam} to construct instances of these
  classes, with \code{ParallelParam} instances created by, e.g.,
  \code{MulticoreParam}.

}

\section{Methods}{See \code{\link{Consumer}} Methods.}

\section{Internal Class Fields and Methods}{

  Internal fields of this class are are described with, e.g.,
  \code{getRefClass("MulticoreTeam")$fields}.

  Internal methods of this class are described with
  \code{getRefClass("MulticoreTeam")$methods()} and
  \code{getRefClass("MulticoreTeam")$help()}.

}

\author{Martin Morgan \url{mtmorgan@fhcrc.org}}

\seealso{

  \code{\link{Team}} applies a single function across multiple threads..

}

\examples{
df <- data.frame(From = c("A", "A", "B", "C"),
                 To   = c("B", "C", "D", "D"),
                 stringsAsFactors=FALSE)
dagParam <- DAGParam(df)
dteam <- DAGTeam(A=FunctionConsumer(function(y) y),
                 B=FunctionConsumer(function(A) -A),
                 C=FunctionConsumer(function(A) 1 / A),
                 D=FunctionConsumer(function(B, C) B + C),
                 dagParam=dagParam)

plot(dteam)

strm <- Stream(Seq(to=10), dteam)
sapply(strm, c)
reset(strm)

}

\keyword{classes}
