% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeWindow.R
\name{makeWindow}
\alias{makeWindow}
\title{Creates a window for a PPP object}
\usage{
makeWindow(data, window = "square", window.length = NULL)
}
\arguments{
\item{data}{A single image data frame from a SingleCellExperiment object or PPP object.}

\item{window}{The shape of window around the regions, can be `square`, `convex` or `concave`}

\item{window.length}{A tuning parameter for controlling the level of concavity when estimating concave windows.}
}
\value{
Creates an `owin` class, representing the observation window for the image.
}
\description{
This function creates a window for a `spatstat::ppp` object, the type of
window can be specified using the `window` argument.
}
\examples{
data <- data.frame(x = rnorm(10), y = rnorm(10))
ow <- makeWindow(data, window = "square")

spatstat.geom::ppp(x = data$x, y = data$y, window = ow)

}
