% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difference_functions.R
\name{label_shuffling}
\alias{label_shuffling}
\title{Calculate p-values using label shuffling.}
\usage{
label_shuffling(
  x,
  samples,
  control,
  method,
  randomizations = 100,
  pcorr = "BH"
)
}
\arguments{
\item{x}{A \code{matrix} with the splicing diversity values.}

\item{samples}{Character vector with an equal length to the number of columns
in the input dataset, specifying the category of each sample.}

\item{control}{Name of the control sample category, defined in the
\code{samples} vector, e.g. \code{control = 'Normal'} or \code{control = 'WT'}.}

\item{method}{Method to use for calculating the average splicing diversity
value in a condition. Can be \code{'mean'} or \code{'median'}.}

\item{randomizations}{The number of random shuffles.}

\item{pcorr}{P-value correction method applied to the results, as defined in
the \code{p.adjust} function.}
}
\value{
Raw and corrected p-values.
}
\description{
Calculate p-values using label shuffling.
}
