% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covDataObject-methods.R,
%   R/covPlotObject-methods.R
\name{covDataObject-class}
\alias{covDataObject-class}
\alias{showEvents}
\alias{showEvents,covDataObject-method}
\alias{getCoverageData}
\alias{getGenomeData}
\alias{plotAnnoTrack}
\title{Container to hold raw data for SpliceWiz coverage plots}
\usage{
\S4method{showEvents}{covDataObject}(object)

getCoverageData(
  se,
  Event,
  Gene,
  seqname,
  start,
  end,
  coordinates,
  strand = c("*", "+", "-"),
  zoom_factor = 0.2,
  bases_flanking = 100,
  tracks,
  condition,
  ...
)

getGenomeData(
  reference_path,
  Gene,
  seqname,
  start,
  end,
  coordinates,
  zoom_factor = 0.2,
  bases_flanking = 100,
  ...
)

plotAnnoTrack(
  object,
  Event,
  view_start,
  view_end,
  reverseGenomeCoords = FALSE,
  condensed = FALSE,
  selected_transcripts = "",
  plot_key_isoforms = FALSE,
  usePlotly = FALSE,
  ...
)
}
\arguments{
\item{object}{For \code{plotAnnoTrack()}, the \code{covDataObject} created by
\code{getCoverageData()} or \code{getGenomeData()}}

\item{se}{A \linkS4class{NxtSE} object, created by \link{makeSE}.
COV files must be linked to the NxtSE object. To do this, see the example
in \link{makeSE}. Required by \code{plotCoverage}. Not required by \code{plotGenome} if
\code{reference_path} is supplied.}

\item{Event}{The \code{EventName} of the IR / alternative splicing event to be
displayed. Use \code{rownames(se)} to display a list of valid events.}

\item{Gene}{Whether to use the range for the given \code{Gene}. If given,
overrides \code{Event} (but \code{Event} or \code{norm_event} will be used to normalise by
condition). Valid \code{Gene} entries include gene_id (Ensembl ID) or gene_name
(Gene Symbol).}

\item{seqname, start, end}{The chromosome (string) and genomic \code{start/end}
coordinates (numeric) of the region to display. If present, overrides both
\code{Event} and \code{Gene}. E.g. for a given region of chr1:10000-11000,
use the parameters: \verb{seqname = "chr1", start = 10000, end = 11000}}

\item{coordinates}{A string specifying genomic coordinates can be given
instead of \verb{seqname,start,end}. Must be of the format "chr:start-end", e.g.
"chr1:10000-11000"}

\item{strand}{Whether to show coverage of both strands "*" (default), or
from the "+" or "-" strand only.}

\item{zoom_factor}{Zoom out from event. Each level of zoom zooms out by a
factor of 3. E.g. for a query region of chr1:10000-11000, if a
\code{zoom_factor} of 1.0 is given, chr1:99000-12000 will be displayed.}

\item{bases_flanking}{(Default = \code{100}) How many bases flanking the zoomed
window. Useful when
used in conjunction with zoom_factor == 0. E.g. for a given region of
chr1:10000-11000, if \code{zoom_factor = 0} and \code{bases_flanking = 100}, the
region chr1:9900-11100 will be displayed.}

\item{tracks}{The names of individual samples,
or the names of the different conditions to be plotted. For the latter, set
\code{condition} to the specified condition category.}

\item{condition}{To display normalised coverage per condition, set this to
the condition category. If omitted, \code{tracks} are assumed to refer to the
names of individual samples.}

\item{...}{Ignored / not used}

\item{reference_path}{The path of the reference generated by
\link{Build-Reference-methods}. Required by \code{plotGenome} if a
\linkS4class{NxtSE} object is not specified.}

\item{view_start, view_end}{Start and end coordinates of plotting function.
Note that plot coordinates may be different from retrieval coordinates
and is useful for zooming in.}

\item{reverseGenomeCoords}{Whether the genomic axis should be reversed
to make it more convenient to plot reverse-stranded genes}

\item{condensed}{(default `FALSE)
Whether the genomic track should be condensed to plot whole
genes, rather than transcripts. Preferred if multiple genes are plotted
on a zoomed-out plot}

\item{selected_transcripts}{(default \code{""}) One or more transcript names or
ID's to be displayed on the annotation track.}

\item{plot_key_isoforms}{(default \code{FALSE}) If \code{TRUE}, plots only transcripts
involved in the given splicing \code{Event}.}

\item{usePlotly}{(default \code{FALSE})
Whether to return a plotly or ggplot object.}
}
\value{
For getCoverageData(): A covDataObject containing required data used to
generate downstream
For plotAnnoTrack(): A ggplot or plotly object
}
\description{
This object is generated using getCoverageData or getGenomeData methods, and
is used as input for generating coverage plots.
}
\section{Functions}{
\itemize{
\item \code{showEvents(covDataObject)}: Returns the EventNames for which events can
be normalized using the given covDataObject

\item \code{getCoverageData()}: Get coverage / genome data for plotting
coverage plots

\item \code{getGenomeData()}: Get coverage / genome data for plotting
coverage plots

\item \code{plotAnnoTrack()}: Directly plots the annotation from a
covDataObject.

}}
\examples{
se <- SpliceWiz_example_NxtSE(novelSplicing = TRUE)

# Assign annotation of the experimental conditions
colData(se)$treatment <- rep(c("A", "B"), each = 3)

dataObj <- getCoverageData(
    se,
    Event = "SE:SRSF3-203-exon4;SRSF3-202-int3",
    tracks = colnames(se)
)

# Show `EventName`s of supported splicing events 
# contained within covDataObject

showEvents(dataObj)

# A limited covDataObject containing only the reference can be generated
# from the SpliceWiz reference

buildRef(
    reference_path = file.path(tempdir(), "Reference"),
    fasta = chrZ_genome(),
    gtf = chrZ_gtf()
)

genomeObj <- getGenomeData(
    reference_path = file.path(tempdir(), "Reference"),
    Gene = "SRSF3"
)

# Plot reference track directly from the covDataObject

# NB: Event plotting is not supported for reference-derived `covDataObject`s
plotAnnoTrack(genomeObj) 

plotAnnoTrack(dataObj, Event = "SE:SRSF3-203-exon4;SRSF3-202-int3") 

}
\seealso{
\linkS4class{covPlotObject}
}
