% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-functions.R, R/Spectra.R
\name{deisotopeSpectra}
\alias{deisotopeSpectra}
\alias{reduceSpectra}
\alias{filterPrecursorMaxIntensity}
\alias{filterPrecursorIsotopes}
\alias{filterPrecursorPeaks}
\alias{filterMsLevel}
\alias{[,Spectra-method}
\alias{filterAcquisitionNum}
\alias{filterDataOrigin}
\alias{filterDataStorage}
\alias{filterEmptySpectra}
\alias{filterIsolationWindow}
\alias{filterPolarity}
\alias{filterPrecursorCharge}
\alias{filterPrecursorMzRange}
\alias{filterPrecursorMzValues}
\alias{filterPrecursorScan}
\alias{filterRanges}
\alias{filterRt}
\alias{filterValues}
\alias{dropNaSpectraVariables}
\alias{selectSpectraVariables}
\alias{filterIntensity}
\alias{filterMzRange}
\alias{filterMzValues}
\alias{dropNaSpectraVariables,Spectra-method}
\alias{selectSpectraVariables,Spectra-method}
\alias{filterAcquisitionNum,Spectra-method}
\alias{filterEmptySpectra,Spectra-method}
\alias{filterDataOrigin,Spectra-method}
\alias{filterDataStorage,Spectra-method}
\alias{filterFourierTransformArtefacts,Spectra-method}
\alias{filterIntensity,Spectra-method}
\alias{filterIsolationWindow,Spectra-method}
\alias{filterMsLevel,Spectra-method}
\alias{filterMzRange,Spectra-method}
\alias{filterMzValues,Spectra-method}
\alias{filterPolarity,Spectra-method}
\alias{filterPrecursorMz,Spectra-method}
\alias{filterPrecursorMzRange,Spectra-method}
\alias{filterPrecursorMzValues,Spectra-method}
\alias{filterPrecursorCharge,Spectra-method}
\alias{filterPrecursorScan,Spectra-method}
\alias{filterRt,Spectra-method}
\alias{filterRanges,Spectra-method}
\alias{filterValues,Spectra-method}
\title{Filter and subset Spectra objects}
\usage{
deisotopeSpectra(
  x,
  substDefinition = isotopicSubstitutionMatrix("HMDB_NEUTRAL"),
  tolerance = 0,
  ppm = 20,
  charge = 1
)

reduceSpectra(x, tolerance = 0, ppm = 20)

filterPrecursorMaxIntensity(x, tolerance = 0, ppm = 20)

filterPrecursorIsotopes(
  x,
  tolerance = 0,
  ppm = 20,
  substDefinition = isotopicSubstitutionMatrix("HMDB_NEUTRAL")
)

filterPrecursorPeaks(
  object,
  tolerance = 0,
  ppm = 20,
  mz = c("==", ">="),
  msLevel. = uniqueMsLevels(object)
)

\S4method{dropNaSpectraVariables}{Spectra}(object)

\S4method{selectSpectraVariables}{Spectra}(
  object,
  spectraVariables = union(spectraVariables(object), peaksVariables(object))
)

\S4method{[}{Spectra}(x, i, j, ..., drop = FALSE)

\S4method{filterAcquisitionNum}{Spectra}(
  object,
  n = integer(),
  dataStorage = character(),
  dataOrigin = character()
)

\S4method{filterEmptySpectra}{Spectra}(object)

\S4method{filterDataOrigin}{Spectra}(object, dataOrigin = character())

\S4method{filterDataStorage}{Spectra}(object, dataStorage = character())

\S4method{filterFourierTransformArtefacts}{Spectra}(
  object,
  halfWindowSize = 0.05,
  threshold = 0.2,
  keepIsotopes = TRUE,
  maxCharge = 5,
  isotopeTolerance = 0.005
)

\S4method{filterIntensity}{Spectra}(
  object,
  intensity = c(0, Inf),
  msLevel. = uniqueMsLevels(object),
  ...
)

\S4method{filterIsolationWindow}{Spectra}(object, mz = numeric())

\S4method{filterMsLevel}{Spectra}(object, msLevel. = integer())

\S4method{filterMzRange}{Spectra}(
  object,
  mz = numeric(),
  msLevel. = uniqueMsLevels(object),
  keep = TRUE
)

\S4method{filterMzValues}{Spectra}(
  object,
  mz = numeric(),
  tolerance = 0,
  ppm = 20,
  msLevel. = uniqueMsLevels(object),
  keep = TRUE
)

\S4method{filterPolarity}{Spectra}(object, polarity = integer())

\S4method{filterPrecursorMz}{Spectra}(object, mz = numeric())

\S4method{filterPrecursorMzRange}{Spectra}(object, mz = numeric())

\S4method{filterPrecursorMzValues}{Spectra}(object, mz = numeric(), ppm = 20, tolerance = 0)

\S4method{filterPrecursorCharge}{Spectra}(object, z = integer())

\S4method{filterPrecursorScan}{Spectra}(object, acquisitionNum = integer(), f = dataOrigin(object))

\S4method{filterRt}{Spectra}(object, rt = numeric(), msLevel. = integer())

\S4method{filterRanges}{Spectra}(
  object,
  spectraVariables = character(),
  ranges = numeric(),
  match = c("all", "any")
)

\S4method{filterValues}{Spectra}(
  object,
  spectraVariables = character(),
  values = numeric(),
  ppm = 0,
  tolerance = 0,
  match = c("all", "any")
)
}
\arguments{
\item{x}{\code{Spectra} object.}

\item{substDefinition}{For \code{deisotopeSpectra()} and
\code{filterPrecursorIsotopes()}: \code{matrix} or \code{data.frame} with definitions
of isotopic substitutions. Uses by default isotopic substitutions
defined from all compounds in the Human Metabolome Database (HMDB). See
\code{\link[MetaboCoreUtils:isotopologues]{MetaboCoreUtils::isotopologues()}} or
\code{\link[MetaboCoreUtils:isotopicSubstitutionMatrix]{MetaboCoreUtils::isotopicSubstitutionMatrix()}} in the
\emph{MetaboCoreUtils} for details.}

\item{tolerance}{For \code{filterMzValues()} and \code{reduceSpectra()}:
\code{numeric(1)} allowing to define a constant maximal accepted difference
between m/z values for peaks to be matched (or grouped). For
\code{containsMz()} it can also be of length equal \code{mz} to specify a different
tolerance for each m/z value.
For \code{filterPrecursorMaxIntensity()}: \code{numeric(1)} defining the
(constant) maximal accepted difference of precursor m/z values of
spectra for grouping them into \emph{precursor groups}. For
\code{filterPrecursorIsotopes()}: passed directly to the
\code{\link[MetaboCoreUtils:isotopologues]{MetaboCoreUtils::isotopologues()}}
function. For \code{filterValues()}: \code{numeric} of any length allowing to
define a maximal accepted difference between user input \code{values} and the
\code{spectraVariables} values. If it is not equal to the length of the
value provided with parameter \code{spectraVariables}, \code{tolerance[1]} will be
recycled. Default is \code{tolerance = 0}.}

\item{ppm}{For \code{filterMzValues()} and \code{reduceSpectra()}: \code{numeric(1)}
defining a relative, m/z-dependent, maximal accepted difference between
m/z values for peaks to be matched (or grouped).
For \code{filterPrecursorMaxIntensity()}: \code{numeric(1)} defining the relative
maximal accepted difference of precursor m/z values of spectra for
grouping them into \emph{precursor groups}. For \code{filterPrecursorIsotopes()}:
passed directly to the \code{\link[MetaboCoreUtils:isotopologues]{MetaboCoreUtils::isotopologues()}} function.
For \code{filterValues()}: \code{numeric} of any length allowing to define
a maximal accepted difference between user input \code{values} and the
\code{spectraVariables} values. If it is not equal to the length of the
value provided with parameter \code{spectraVariables}, \code{ppm[1]} will be
recycled.}

\item{charge}{For \code{deisotopeSpectra()}: expected charge of the ionized
compounds. See \code{\link[MetaboCoreUtils:isotopologues]{MetaboCoreUtils::isotopologues()}} for details.}

\item{object}{\code{Spectra} object.}

\item{mz}{For \code{filterIsolationWindow()}: \code{numeric(1)} with the m/z value to
filter the object. For \code{filterPrecursorMz()} and \code{filterMzRange()}:
\code{numeric(2)} defining the lower and upper m/z boundary.
For \code{filterMzValues()} and \code{filterPrecursorMzValues()}: \code{numeric} with
the m/z values to match peaks or precursor m/z against.
For \code{filterPrecursorPeaks()}: \code{character(1)} defining whether mass peaks
with an m/z matching the spectrum's precursor m/z (\code{mz = "=="},
the default) or mass peaks with a m/z that is equal or larger
(\code{mz = ">="}) should be removed.}

\item{msLevel.}{\code{integer} defining the MS level(s) of the spectra to which
the function should be applied (defaults to all MS levels of \code{object}.
For \code{filterMsLevel()}: the MS level to which \code{object} should be
subsetted.}

\item{spectraVariables}{For \code{selectSpectraVariables()}: \code{character} with the
names of the spectra variables to which the backend should be
subsetted. For \code{filterRanges()} and \code{filterValues()}: \code{character}
vector specifying the column(s) from \code{spectraData(object)} on which
to filter the data and that correspond to the the names of the
spectra variables that should be used for the filtering.}

\item{i}{For \code{[}: \code{integer}, \code{logical} or \code{character} to subset the
object.}

\item{j}{For \code{[}: not supported.}

\item{...}{Additional arguments.}

\item{drop}{For \code{[}: not considered.}

\item{n}{for \code{filterAcquisitionNum()}: \code{integer} with the acquisition
numbers to filter for.}

\item{dataStorage}{For \code{filterDataStorage()}: \code{character} to define which
spectra to keep.
For \code{filterAcquisitionNum()}: optionally specify if filtering should
occur only for spectra of selected \code{dataStorage}.}

\item{dataOrigin}{For \code{filterDataOrigin()}: \code{character} to define which
spectra to keep.
For \code{filterAcquisitionNum()}: optionally specify if filtering should
occurr only for spectra of selected \code{dataOrigin}.}

\item{halfWindowSize}{For \code{filterFourierTransformArtefacts()}: \code{numeric(1)}
defining the m/z window left and right of a peak where to remove
fourier transform artefacts.}

\item{threshold}{For \code{filterFourierTransformArtefacts()}: the relative
intensity (to a peak) below which peaks are considered fourier
artefacts. Defaults to \code{threshold = 0.2} hence removing peaks that
have an intensity below 0.2 times the intensity of the tested peak
(within the selected \code{halfWindowSize}).}

\item{keepIsotopes}{For \code{filterFourierTransformArtefacts()}: whether isotope
peaks should not be removed as fourier artefacts.}

\item{maxCharge}{For \code{filterFourierTransformArtefacts()}: the maximum charge
to be considered for isotopes.}

\item{isotopeTolerance}{For \code{filterFourierTransformArtefacts()}: the m/z
\code{tolerance} to be used to define whether peaks might be isotopes of
the current tested peak.}

\item{intensity}{For \code{filterIntensity()}: \code{numeric} of length 1 or 2
defining either the lower or the lower and upper intensity limit for the
filtering, or a \code{function} that takes the intensities as input and
returns a \code{logical} (same length then peaks in the spectrum) whether the
peak should be retained or not. Defaults to \code{intensity = c(0, Inf)} thus
only peaks with \code{NA} intensity are removed.}

\item{keep}{For \code{filterMzValues()} and \code{filterMzRange()}: \code{logical(1)}
whether  the matching peaks should be retained (\code{keep = TRUE}, the
default) or dropped (\code{keep = FALSE}).}

\item{polarity}{for \code{filterPolarity()}: \code{integer} specifying the polarity to
to subset \code{object}.}

\item{z}{For \code{filterPrecursorCharge()}: \code{integer()} with the precursor
charges to be used as filter.}

\item{acquisitionNum}{for \code{filterPrecursorScan()}: \code{integer} with the
acquisition number of the spectra to which the object should be
subsetted.}

\item{f}{For \code{filterPrecursorScan()}: defining which spectra
belong to the same original data file (sample): Defaults to
\code{f = dataOrigin(x)}.}

\item{rt}{for \code{filterRt()}: \code{numeric(2)} defining the retention time range to
be used to subset/filter \code{object}.}

\item{ranges}{for \code{filterRanges()}: A \code{numeric} vector of paired values
(upper and lower boundary) that define the ranges to filter the \code{object}.
These paired values need to be in the same order as the
\code{spectraVariables} parameter (see below).}

\item{match}{For \code{filterRanges()} and \code{filterValues()}: \code{character(1) }
defining whether the condition has to match for all provided
\code{ranges}/\code{values} (\code{match = "all"}; the default), or for any of them
(\code{match = "any"}) for spectra to be retained.}

\item{values}{for \code{filterValues()}: A \code{numeric} vector that define the
values to filter the Spectra data. These values need to be in the same
order as the \code{spectraVariables} parameter.}
}
\description{
A variety of functions to filter or subset \code{Spectra} objects are available.
These can be generally separated into two main classes: I) \emph{classical}
subset operations that immediately reduce the number of spectra in the
object and II) filters that reduce the \strong{content} of the object without
changing its length (i.e. the number of spectra). The latter can be further
subdivided into functions that affect the content of the \code{spectraData} (i.e.
the general spectrum metadata) and those that reduce the content of the
object's \code{peaksData} (i.e. the m/z and intensity values of a spectrum's
mass peaks).

A description of functions from these 3 different categories are given below
in sections \emph{Subset \code{Spectra}}, \emph{Filter content of \code{spectraData()}} and
\emph{Filter content of \code{peaksData()}}, respectively.
}
\section{Subset \code{Spectra}}{


These functions affect the number of spectra in a \code{Spectra} object creating
a subset of the original object without affecting its content.
\itemize{
\item \code{[}: subsets the spectra keeping only selected elements (\code{i}). The method
\strong{always} returns a \code{Spectra} object.
\item \code{filterAcquisitionNum()}: filters the object keeping only spectra matching
the provided acquisition numbers (argument \code{n}). If \code{dataOrigin} or
\code{dataStorage} is also provided, \code{object} is subsetted to the spectra with
an acquisition number equal to \code{n} \strong{in spectra with matching dataOrigin
or dataStorage values} retaining all other spectra.
Returns the filtered \code{Spectra}.
\item \code{filterDataOrigin()}: filters the object retaining spectra matching the
provided \code{dataOrigin}. Parameter \code{dataOrigin} has to be of type
\code{character} and needs to match exactly the data origin value of the
spectra to subset.
Returns the filtered \code{Spectra} object (with spectra ordered according to
the provided \code{dataOrigin} parameter).
\item \code{filterDataStorage()}: filters the object retaining spectra stored in the
specified \code{dataStorage}. Parameter \code{dataStorage} has to be of type
\code{character} and needs to match exactly the data storage value of the
spectra to subset.
Returns the filtered \code{Spectra} object (with spectra ordered according to
the provided \code{dataStorage} parameter).
\item \code{filterEmptySpectra()}: removes empty spectra (i.e. spectra without peaks).
Returns the filtered \code{Spectra} object (with spectra in their
original order).
\item \code{filterIsolationWindow()}: retains spectra that contain \code{mz} in their
isolation window m/z range (i.e. with an \code{isolationWindowLowerMz} <= \code{mz}
and \code{isolationWindowUpperMz} >= \code{mz}. Returns the filtered \code{Spectra}
object (with spectra in their original order).
\item \code{filterMsLevel()}: filters object by MS level keeping only spectra matching
the MS level specified with argument \code{msLevel}. Returns the filtered
\code{Spectra} (with spectra in their original order).
\item \code{filterPolarity()}: filters the object keeping only spectra matching the
provided polarity. Returns the filtered \code{Spectra} (with spectra in their
original order).
\item \code{filterPrecursorCharge()}: retains spectra with the defined precursor
charge(s).
\item \code{filterPrecursorIsotopes()}: groups MS2 spectra based on their precursor
m/z and precursor intensity into predicted isotope groups and keep for each
only the spectrum representing the monoisotopic precursor. MS1 spectra
are returned as is. See documentation for \code{deisotopeSpectra()} below for
details on isotope prediction and parameter description.
\item \code{filterPrecursorMaxIntensity()}: filters the \code{Spectra} keeping for groups
of (MS2) spectra with similar precursor m/z values (given parameters
\code{ppm} and \code{tolerance}) the one with the highest precursor intensity. The
function filters only MS2 spectra and returns all MS1 spectra. If
precursor intensities are \code{NA} for all spectra within a spectra group, the
first spectrum of that groups is returned.
Note: some manufacturers don't provide precursor intensities. These can
however also be estimated with \code{\link[=estimatePrecursorIntensity]{estimatePrecursorIntensity()}}.
\item \code{filterPrecursorMzRange()} (previously \code{filterPrecursorMz()} which is now
deprecated): retains spectra with a precursor m/z within the
provided m/z range. See examples for details on selecting spectra with
a precursor m/z for a target m/z accepting a small difference in \emph{ppm}.
\item \code{filterPrecursorMzValues()}: retains spectra with precursor m/z matching
any of the provided m/z values (given \code{ppm} and \code{tolerance}). Spectra with
missing precursor m/z value (e.g. MS1 spectra) are dropped.
\item \code{filterPrecursorScan()}: retains parent (e.g. MS1) and children scans (e.g.
MS2) of acquisition number \code{acquisitionNum}. Returns the filtered
\code{Spectra} (with spectra in their original order). Parameter \code{f} allows to
define which spectra belong to the same sample or original data file
(defaults to \code{f = dataOrigin(object)}). See also \code{\link[=fragmentGroupIndex]{fragmentGroupIndex()}} for
a function to generate an \code{integer} index grouping MS^n spectra with their
corresponding MS1 spectra based on acquisition order.
\item \code{filterRanges()}: allows filtering of the \code{Spectra} object based on user
defined \emph{numeric} ranges (parameter \code{ranges}) for one or more available
spectra variables in object (spectra variable names can be specified with
parameter \code{spectraVariables}). Spectra for which the value of a spectra
variable is within it's defined range are retained. If multiple
ranges/spectra variables are defined, the \code{match} parameter can be used
to specify whether all conditions (\code{match = "all"}; the default) or if
any of the conditions must match (\code{match = "any"}; all spectra for which
values are within any of the provided ranges are retained).
\item \code{filterRt()}: retains spectra of MS level \code{msLevel} with retention
times (in seconds) within (\code{>=}) \code{rt[1]} and (\code{<=})
\code{rt[2]}. This retention time filter is applied to all spectra (regardless
of their MS level) if \code{msLevel. = integer()} (the default). Returns the
filtered \code{Spectra} (with spectra in their original order).
\item \code{filterValues()}: allows filtering of the \code{Spectra} object based on
similarities of \emph{numeric} values of one or more \code{spectraVariables(object)}
(parameter \code{spectraVariables}) to provided values (parameter \code{values})
given acceptable differences (parameters tolerance and ppm). If multiple
values/spectra variables are defined, the \code{match} parameter can be used
to specify whether all conditions (\code{match = "all"}; the default) or if
any of the conditions must match (\code{match = "any"}; all spectra for which
values are within any of the provided ranges are retained).
}
}

\section{Filter content of \code{spectraData()}}{


The functions described in this section filter the content from a
\code{Spectra}'s spectra data, i.e. affect values of, or complete, spectra
variables. None of these functions reduces the object's number of spectra.
\itemize{
\item \code{dropNaSpectraVariables()}: removes spectra variables (i.e. columns in the
object's \code{spectraData} that contain only missing values (\code{NA}). Note that
while columns with only \code{NA}s are removed, a \code{spectraData()} call after
\code{dropNaSpectraVariables()} might still show columns containing \code{NA} values
for \emph{core} spectra variables. The total number of spectra is not changed
by this function.
\item \code{selectSpectraVariables()}: reduces the information within the object to
the selected spectra variables: all data for variables not specified will
be dropped. For mandatory columns (i.e., those listed by
\code{\link[=coreSpectraVariables]{coreSpectraVariables()}}, such as \emph{msLevel}, \emph{rtime} ...) only
the values will be dropped but not the variable itself. Additional (or
user defined) spectra variables will be completely removed.
Returns the filtered \code{Spectra}.
}
}

\section{Filter content of \code{peaksData()}}{


The functions described in this section filter the content of the
\code{Spectra}'s peaks data, i.e. either the number or the values (\emph{m/z} or
intensity values) of the mass peaks. Also, the actual operation is only
executed once peaks data is accessed (through \code{peaksData()},
\code{mz()} or \code{intensity()}) or \code{applyProcessing()} is called.
These operations don't affect the number of spectra in the \code{Spectra} object.
\itemize{
\item \code{deisotopeSpectra()}: \emph{deisotopes} each spectrum keeping only the
monoisotopic peak for groups of isotopologues. Isotopologues are
estimated using the \code{\link[MetaboCoreUtils:isotopologues]{MetaboCoreUtils::isotopologues()}} function from the
\emph{MetaboCoreUtils} package. Note that
the default parameters for isotope prediction/detection have been
determined using data from the Human Metabolome Database (HMDB) and
isotopes for elements other than CHNOPS might not be detected. See
parameter \code{substDefinition} in the documentation of
\code{\link[MetaboCoreUtils:isotopologues]{MetaboCoreUtils::isotopologues()}} for
more information. The approach and code to define the parameters for
isotope prediction is described
\href{https://github.com/EuracBiomedicalResearch/isotopologues}{here}.
\item \code{filterFourierTransformArtefacts()}: removes (Orbitrap) fast fourier
artefact peaks from spectra (see examples below). The function iterates
through all intensity ordered peaks in a spectrum and removes all peaks
with an m/z within +/- \code{halfWindowSize} of the current peak if their
intensity is lower than \code{threshold} times the current peak's intensity.
Additional parameters \code{keepIsotopes}, \code{maxCharge} and \code{isotopeTolerance}
allow to avoid removing of potential \verb{[13]C} isotope peaks (\code{maxCharge}
being the maximum charge that should be considered and \code{isotopeTolerance}
the absolute acceptable tolerance for matching their m/z).
See \code{\link[=filterFourierTransformArtefacts]{filterFourierTransformArtefacts()}} for details and background and
\code{deisitopeSpectra()} for an alternative.
\item \code{filterIntensity()}: filters mass peaks in each spectrum keeping only
those with intensities that are within the provided range or match the
criteria of the provided function. For the former, parameter \code{intensity}
has to be a \code{numeric} defining the intensity range, for the latter a
\code{function} that takes the intensity values of the spectrum and returns
a \code{logical} whether the peak should be retained or not (see examples
below for details) - additional parameters to the function can be passed
with \code{...}.
To remove only peaks with intensities below a certain threshold, say
100, use \code{intensity = c(100, Inf)}. Note: also a single value can be
passed with the \code{intensity} parameter in which case an upper limit of
\code{Inf} is used.
Note that this function removes also peaks with missing intensities
(i.e. an intensity of \code{NA}). Parameter \code{msLevel.} allows to restrict the
filtering to spectra of the specified MS level(s).
\item \code{filterMzRange()}: filters mass peaks in the object keeping or removing
those in each spectrum that are within the provided m/z range. Whether
peaks are retained or removed can be configured with parameter \code{keep}
(default \code{keep = TRUE}).
\item \code{filterMzValues()}: filters mass peaks in the object keeping all
peaks in each spectrum that match the provided m/z value(s) (for
\code{keep = TRUE}, the default) or removing all of them (for \code{keep = FALSE}).
The m/z matching considers also the absolute \code{tolerance} and m/z-relative
\code{ppm} values. \code{tolerance} and \code{ppm} have to be of length 1.
\item \code{filterPeaksRanges()}: filters mass peaks of a \code{Spectra} object using any
set of range-based filters on numeric spectra or peaks variables. See
\code{\link[=filterPeaksRanges]{filterPeaksRanges()}} for more information.
\item \code{filterPrecursorPeaks()}: removes peaks from each spectrum in \code{object} with
an m/z equal or larger than the m/z of the precursor, depending on the
value of parameter \code{mz}: for \verb{mz = ==" (the default) peaks with matching m/z (considering an absolute and relative acceptable difference depending on }tolerance\code{and}ppm\verb{, respectively) are removed. For }mz = ">="\verb{all peaks with an m/z larger or equal to the precursor m/z (minus}tolerance\verb{and the}ppm\verb{of the precursor m/z) are removed. Parameter}msLevel.\verb{allows to restrict the filter to certain MS levels (by default the filter is applied to all MS levels). Note that no peaks are removed if the precursor m/z is}NA` (e.g. typically for MS1 spectra).
\item \code{reduceSpectra()}: keeps for groups of peaks with similar m/z values in
(given \code{ppm} and \code{tolerance}) in each spectrum only the mass peak with the
highest intensity removing all other peaks hence \emph{reducing} each
spectrum to the highest intensity peaks per \emph{peak group}.
Peak groups are defined using the \code{\link[MsCoreUtils:group]{MsCoreUtils::group()}} function from the
\emph{MsCoreUtils} package. See also the \code{\link[=combinePeaks]{combinePeaks()}} function for an
alternative function to combine peaks within each spectrum.
}
}

\examples{

## Load a `Spectra` object with LC-MS/MS data.
fl <- system.file("TripleTOF-SWATH", "PestMix1_DDA.mzML",
    package = "msdata")
sps_dda <- Spectra(fl)
sps_dda


##  --------  SUBSET SPECTRA  --------

## Subset to the first 3 spectra
tmp <- sps_dda[1:3]
tmp
length(tmp)

## Subset to all MS2 spectra; this could be done with [, or, more
## efficiently, with the `filterMsLevel` function:
sps_dda[msLevel(sps_dda) == 2L]
filterMsLevel(sps_dda, 2L)

## Filter the object keeping only MS2 spectra with an precursor m/z value
## between a specified range:
filterPrecursorMzRange(sps_dda, c(80, 90))

## Filter the object to MS2 spectra with an precursor m/z matching a
## pre-defined value (given ppm and tolerance)
filterPrecursorMzValues(sps_dda, 85, ppm = 5, tolerance = 0.1)

## The `filterRanges()` function allows to filter a `Spectra` based on
## numerical ranges of any of its (numerical) spectra variables.
## First, determine the variable(s) on which to base the filtering:
sv <- c("rtime", "precursorMz", "peaksCount")
## Note that ANY variables can be chosen here, and as many as wanted.

## Define the ranges (pairs of values with lower and upper boundary) to be
## used for the individual spectra variables. The first two values will be
## used for the first spectra variable (e.g., `"rtime"` here), the next two
## for the second (e.g. `"precursorMz"` here) and so on:
ranges <- c(30, 350, 200, 500, 350, 600)

## Input the parameters within the filterRanges function:
filt_spectra <- filterRanges(sps_dda, spectraVariables = sv,
                ranges = ranges)
filt_spectra

## `filterRanges()` can also be used to filter a `Spectra` object with
## multiple ranges for the same `spectraVariable` (e.g, here `"rtime"`)
sv <- c("rtime", "rtime")
ranges <- c(30, 100, 200, 300)
filt_spectra <- filterRanges(sps_dda, spectraVariables = sv,
                ranges = ranges, match = "any")
filt_spectra

## While `filterRanges()` filtered on numeric ranges, `filterValues()`
## allows to filter an object matching spectra variable values to user
## provided values (allowing to configure allowed differences using the
## `ppm` and `tolerance` parameters).
## First determine the variable(s) on which to base the filtering:
sv <- c("rtime", "precursorMz")
## Note that ANY variables can be chosen here, and as many as wanted.

## Define the values that will be used to filter the spectra based on their
## similarities to their respective `spectraVariables`.
## The first values in the parameters values, tolerance and ppm will be
## used for the first spectra variable (e.g. `"rtime"` here), the next for
## the second (e.g. `"precursorMz"` here) and so on:
values <- c(350, 80)
tolerance <- c(100, 0.1)
ppm <- c(0, 50)

## Input the parameters within the `filterValues()` function:
filt_spectra <- filterValues(sps_dda, spectraVariables = sv,
                values = values, tolerance = tolerance, ppm = ppm)
filt_spectra


##  --------  FILTER SPECTRA DATA  --------

## Remove spectra variables without content (i.e. with only missing values)
sps_noNA <- dropNaSpectraVariables(sps_dda)

## This reduced the size of the object slightly
print(object.size(sps_dda), unit = "MB")
print(object.size(sps_noNA), unit = "MB")

## With the `selectSpectraVariables()` function it is in addition possible
## to subset the data of a `Spectra` to the selected columns/variables,
## keeping only their data:
tmp <- selectSpectraVariables(sps_dda, c("msLevel", "mz", "intensity",
    "scanIndex"))
print(object.size(tmp), units = "MB")

## Except the selected variables, all data is now removed. Accessing
## core spectra variables still works, but returns only NA
rtime(tmp) |> head()


##  --------  FILTER PEAKS DATA  --------

## `filterMzValues()` filters the mass peaks data of a `Spectra` retaining
## only those mass peaks with an m/z value matching the provided value(s).
sps_sub <- filterMzValues(sps_dda, mz = c(103, 104), tolerance = 0.3)

## The filtered `Spectra` has the same length
length(sps_dda)
length(sps_sub)

## But the number of mass peaks changed
lengths(sps_dda) |> head()
lengths(sps_sub) |> head()

## This function can also be used to remove specific peaks from a spectrum
## by setting `keep = FALSE`.
sps_sub <- filterMzValues(sps_dda, mz = c(103, 104),
    tolerance = 0.3, keep = FALSE)
lengths(sps_sub) |> head()

## With the `filterMzRange()` function it is possible to keep (or remove)
## mass peaks with m/z values within a specified numeric range.
sps_sub <- filterMzRange(sps_dda, mz = c(100, 150))
lengths(sps_sub) |> head()

## See also the `filterPeaksRanges()` function for a more flexible framework
## to filter mass peaks


## Removing fourier transform artefacts seen in Orbitra data.

## Loading an Orbitrap spectrum with artefacts.
data(fft_spectrum)
plotSpectra(fft_spectrum, xlim = c(264.5, 265.5))
plotSpectra(fft_spectrum, xlim = c(264.5, 265.5), ylim = c(0, 5e6))

fft_spectrum <- filterFourierTransformArtefacts(fft_spectrum)
fft_spectrum
plotSpectra(fft_spectrum, xlim = c(264.5, 265.5), ylim = c(0, 5e6))

## Using a few examples peaks in your data you can optimize the parameters
fft_spectrum_filtered <- filterFourierTransformArtefacts(fft_spectrum,
                                               halfWindowSize = 0.2,
                                               threshold = 0.005,
                                               keepIsotopes = TRUE,
                                               maxCharge = 5,
                                               isotopeTolerance = 0.005
                                               )

fft_spectrum_filtered
length(mz(fft_spectrum_filtered)[[1]])
plotSpectra(fft_spectrum_filtered, xlim = c(264.5, 265.5), ylim = c(0, 5e6))


## *Reducing* a `Spectra` keeping for groups of mass peaks (characterized
## by similarity of their m/z values) only one representative peak. This
## function helps cleaning fragment spectra.
## Filter the data set to MS2 spectra
ms2 <- filterMsLevel(sps_dda, 2L)

## For groups of fragment peaks with a difference in m/z < 0.1, keep only
## the largest one.
ms2_red <- reduceSpectra(ms2, ppm = 0, tolerance = 0.1)
lengths(ms2) |> tail()
lengths(ms2_red) |> tail()
}
\seealso{
\itemize{
\item \code{\link[=combineSpectra]{combineSpectra()}} for functions to combine or aggregate \code{Spectra}.
\item \code{\link[=combinePeaks]{combinePeaks()}} for functions to combine or aggregate a \code{Spectra}'s
\code{peaksData()}
}
}
\author{
Sebastian Gibb, Johannes Rainer, Laurent Gatto, Philippine Louail, Nir Shahaf
}
