% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateObject.R
\name{updateObject}
\alias{updateObject}
\alias{updateObject,SpatialFeatureExperiment-method}
\alias{SFEVersion}
\title{Update a SpatialFeatureExperiment object}
\usage{
\S4method{updateObject}{SpatialFeatureExperiment}(object, ..., verbose = FALSE)

SFEVersion(object)
}
\arguments{
\item{object}{An old \linkS4class{SpatialFeatureExperiment} object.}

\item{...}{Additional arguments that are ignored.}

\item{verbose}{Logical scalar indicating whether a message should be emitted
as the object is updated.}
}
\value{
An updated version of \code{object}.
}
\description{
Update a \linkS4class{SpatialFeatureExperiment} to the latest version of
object structure. This is usually called by internal functions.
}
\details{
Version 1.1.4 adds package version to the SFE object. We are considering an
overhaul of the \code{spatialGraphs} slot in a future version using the
\code{sfdep} package to decouple the adjacency graph from the edge weights.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData("small")
# First version of SFE object doesn't log SFE package version, so should be NULL
SFEVersion(sfe)
sfe <- updateObject(sfe)
# See current version
SFEVersion(sfe)
}
\seealso{
\code{\link[SingleCellExperiment]{objectVersion}}, which is used to determine if the
  object is up-to-date.
}
\concept{SpatialFeatureExperiment class}
