% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinySpaniel.R
\name{runShinySpaniel}
\alias{runShinySpaniel}
\title{RunShinySpaniel}
\usage{
runShinySpaniel()
}
\value{
Runs a Shiny App
}
\description{
A function to visualise Spatial Transcriptomics. It requires a prepocessed 
Seurat Object or a SingleCellExperiment object as well as a rasterised image 
saved as an .rds object. There are 4 plots available in the app showing: 
a) the number of genes detected per spot, 
b) the number of reads detected per spot, 
c) clustering results,
d) the gene expression of a selected gene."
To view the clustering results the columns of the meta.data or colData 
containing clustering results must be prefixed with cluster_ . This can be 
done by using the markClusterCol() function included in Spaniel.
}
\examples{
## mark the columns of metadata/colData that contain clustering 
## information see ?markClusterCol for more details#'  
sObj <-  readRDS(file.path(system.file(package = "Spaniel"),
                    "extdata/sceData.rds"))

img <- readRDS(file.path(system.file(package = "Spaniel"),
                    "extdata/image.rds"))

## run shinySpaniel (upload data.rds and image.rds in the shiny app)
## Not Run:
# runShinySpaniel()
}
