% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{checkOutliers}
\alias{checkOutliers}
\title{checkOutliers}
\usage{
checkOutliers(spe, verbose = FALSE)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with spatial omics data.}

\item{verbose}{Logical. If `TRUE`, prints how many outliers were found for
each metric.}
}
\value{
The `SpatialExperiment` object with added QCScore metric variables
 in the `metadata`.
}
\description{
Checks if computed outliers meet the minimum numerical requirement, being
at least 0.1% of total cells for each metric to be used in QC score formula.
If the requirement is not met, the variable is removed from the formula.
}
\details{
The function checks if computed outliers for each metric meet
the minimum number to get the metric included in the QC score formula.
If verbose is TRUE, it also prints how many outliers were found for each
metric.
}
\examples{
example(computeOutliersQCScore)
spe <- checkOutliers(spe, verbose = TRUE)
metadata(spe)$formula_variables
}
