% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{computeLambda}
\alias{computeLambda}
\title{computeLambda}
\usage{
computeLambda(trainDF, modelFormula)
}
\arguments{
\item{trainDF}{`data.frame`
A data frame for training that must include:
  Predictor columns: All columns referenced in the formula returned by `getModelFormula()`.
  `qscore_train` A binary (0/1) response vector to be modeled.}

\item{modelFormula}{`character`
A character string representing the model formula
 `~ log2CountArea + ...`, as returned by `getModelFormula()`.}
}
\value{
`numeric`
  The value of \eqn{\lambda} (i.e., `lambda.min`) from
  `cv.glmnet` that minimizes the cross-validation error.
}
\description{
Compute Optimal Ridge Regularization Parameter \eqn{\lambda} via
Cross-Validation

\code{computeLambda} performs ridge (L2) logistic regression with
cross-validation to identify the optimal regularization parameter
\eqn{\lambda} for a binary response.
}
\details{
Internally, the function:
  Constructs the design matrix via \code{model.matrix()},
  Runs ridge logistic regression cross-validation using `cv.glmnet` with `alpha = 0`,
  Extracts and returns `ridge_cv$lambda.min`.
}
\examples{
example(computeTrainDF)
modform <- getModelFormula(metadata(spe)$formula_variables)
best_lambda <- computeLambda(df_train, modform)
print(best_lambda)


}
