% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterGenes.R
\name{filterGenes}
\alias{filterGenes}
\alias{filterGenes,SpatialExperiment-method}
\alias{filterGenes,Seurat-method}
\title{Filter genes based on expression}
\usage{
filterGenes(spe, prop = 0.1)

\S4method{filterGenes}{SpatialExperiment}(spe, prop = 0.1)

\S4method{filterGenes}{Seurat}(spe, prop = 0.1)
}
\arguments{
\item{spe}{a SpatialExperiment, Seurat, or SpatialFeatureExperiment object containing count data.}

\item{prop}{a numeric, indicating the proportion of loci/cells where the gene should be expressed (default is 0.1, i.e., genes should be expressed in at least 10\% of the loci/cells).}
}
\value{
a logical vector encoding which genes should be kept for further analysis.
}
\description{
This function removes genes that are very lowly expressed.
}
\examples{
data(HumanDLPFC)
keep <- filterGenes(HumanDLPFC)
table(keep)

}
