% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_visualizations.R
\name{plotIntensity}
\alias{plotIntensity}
\title{Plot Intensity Boxplots}
\usage{
plotIntensity(se, colorByCol = "none")
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object containing the assay data and
metadata.}

\item{colorByCol}{A \code{character} string specifying the metadata column
to use for coloring the boxplots. Default is "none".}
}
\value{
A \code{ggplot2} object showing boxplots of intensities for each
sample.
}
\description{
\code{plotIntensity} generates boxplots of assay intensities for each sample
in a \code{SummarizedExperiment} object. Optionally, the boxplots can be
colored based on a specified metadata column. The function handles missing
values by filtering them out before plotting.
}
\examples{
library(SummarizedExperiment)
# Load multiAssayExperiment object
data("dia_example")
# Get SummarizedExperiment object
se <- dia_example[["Phosphoproteome"]]
colData(se) <- colData(dia_example)
# Preprocess the phosphoproteome assay
result <- preprocessPhos(seData = se, normalize = TRUE, impute = "QRILC")
# Call the plotting function
plotIntensity(result, colorByCol = "replicate")

}
