% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.r
\name{PlotAvgSMF}
\alias{PlotAvgSMF}
\title{Plot average methylation}
\usage{
PlotAvgSMF(
  MethGR,
  MethSM = NULL,
  RegionOfInterest,
  SortedReads = NULL,
  ShowContext = FALSE,
  TFBSs = NULL,
  SNPs = NULL,
  SortingBins = NULL
)
}
\arguments{
\item{MethGR}{Average methylation GRanges obj}

\item{MethSM}{Single molecule matrix(es)}

\item{RegionOfInterest}{GRanges interval to plot}

\item{SortedReads}{List of sorted reads, needs to be passed along with the parameter MethSM. If both are passed, only counts relevant to sorting will be plotted}

\item{ShowContext}{TRUE or FALSE (default). Causes the genomic context of the plotted cytosines to be displayed as the dot shape}

\item{TFBSs}{GRanges object of transcription factor binding sites to include in the plot. Assumed to be already subset. Also assumed that the tf names are under the column "TF"}

\item{SNPs}{GRanges object of SNPs to visualize. Assumed to be already subset. Assumed to have the reference and alternative sequences respectively under the columns "R" and "A"}

\item{SortingBins}{GRanges object of sorting bins (absolute) coordinate to visualize}
}
\description{
Plot average methylation
}
\examples{

library(GenomicRanges)

RegionOfInterest = GRanges("chr12", IRanges(20464551, 20465050))
Methylation = qs::qread(system.file("extdata", "Methylation_3.qs", 
package="SingleMoleculeFootprinting"))
TFBSs = qs::qread(system.file("extdata", "TFBSs_3.qs", package="SingleMoleculeFootprinting"))

PlotAvgSMF(MethGR = Methylation[[1]], RegionOfInterest = RegionOfInterest, TFBSs = TFBSs)

}
