% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_calling.r
\name{GetSingleMolMethMat}
\alias{GetSingleMolMethMat}
\title{Get Single Molecule methylation matrix}
\usage{
GetSingleMolMethMat(QuasRprj, range, sample)
}
\arguments{
\item{QuasRprj}{QuasR project object as returned by calling the QuasR function qAling on previously aligned data}

\item{range}{GenimocRange representing the genomic region of interest}

\item{sample}{One of the sample names as reported in the SampleName field of the QuasR sampleFile provided to qAlign. N.b. all the files with the passed sample name will be used to call methylation}
}
\value{
List of single molecule methylation matrixes (all Cytosines), one per sample
}
\description{
Used internally as the first step in CallContextMethylation
}
\examples{

library(BSgenome.Mmusculus.UCSC.mm10)
library(IRanges)
library(GenomicRanges)

CacheDir <- ExperimentHub::getExperimentHubOption(arg = "CACHE")
sampleFile = paste0(CacheDir, "/NRF1Pair_sampleFile.txt")
sample = suppressMessages(readr::read_delim(sampleFile, delim = "\t")[[2]])
QuasRprj = GetQuasRprj(sampleFile, BSgenome.Mmusculus.UCSC.mm10)
range = GRanges("chr6", IRanges(88106000, 88106500))

GetSingleMolMethMat(QuasRprj, range, sample)

}
