% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_calling.r
\name{FilterContextCytosines}
\alias{FilterContextCytosines}
\title{Filter Cytosines in context}
\usage{
FilterContextCytosines(MethGR, genome, context)
}
\arguments{
\item{MethGR}{Granges obj of average methylation}

\item{genome}{BSgenome}

\item{context}{Context of interest (e.g. "GC", "CG",..)}
}
\value{
filtered Granges obj
}
\description{
Filter Cytosines in context
}
\examples{

library(BSgenome.Mmusculus.UCSC.mm10)
MethGR = qs::qread(system.file("extdata", "Methylation_3.qs", 
package="SingleMoleculeFootprinting"))[[1]]

FilterContextCytosines(MethGR, BSgenome.Mmusculus.UCSC.mm10, "NGCNN")

}
