% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/sharedObjectProperty.R
\name{sharedObjectProperties}
\alias{sharedObjectProperties}
\alias{sharedObjectProperties,ANY-method}
\alias{sharedObjectProperties,list-method}
\alias{getCopyOnWrite}
\alias{getSharedSubset}
\alias{getSharedCopy}
\alias{setCopyOnWrite}
\alias{setSharedSubset}
\alias{setSharedCopy}
\title{Get/Set the properties of a shared object.}
\usage{
sharedObjectProperties(x, ..., literal = TRUE)

\S4method{sharedObjectProperties}{ANY}(x, ..., literal = TRUE)

\S4method{sharedObjectProperties}{list}(x, ..., literal = TRUE)

getCopyOnWrite(x)

getSharedSubset(x)

getSharedCopy(x)

setCopyOnWrite(x, value)

setSharedSubset(x, value)

setSharedCopy(x, value)
}
\arguments{
\item{x}{A shared object}

\item{...}{The name of the property(s), it can be either symbols or characters.
if the argument is missing, it means getting all properties. See examples.}

\item{literal}{Whether the parameters in \code{...} are always treated as characters.}

\item{value}{The value of the property}
}
\value{
get: The property(s) of a shared object

set: The old property(s)
}
\description{
Get/Set the properties of a shared object.
}
\details{
For numeric objects, the properties are \code{dataId}, \code{length},
\code{totalSize}, \code{dataType}, \code{ownData}, \code{copyOnWrite}, \code{sharedSubset},
\code{sharedCopy}.

For character objects, the properties are
\code{length}, \code{unitSize},\code{totalSize},\code{dataType},\code{uniqueChar},\code{copyOnWrite}.

Note that only \code{copyOnWrite}, \code{sharedSubset} and \code{sharedCopy} are mutable.
The other attributes are read-only.
}
\examples{
## For numeric objects
x1 <- share(1:10)

## Get attributes
sharedObjectProperties(x1)
sharedObjectProperties(x1, copyOnWrite)
sharedObjectProperties(x1, "copyOnWrite")
props <- "copyOnWrite"
sharedObjectProperties(x1, props, literal = FALSE)
getCopyOnWrite(x1)

## Set attributes
sharedObjectProperties(x1, copyOnWrite = FALSE)
setCopyOnWrite(x1, FALSE)

## For character objects
x2 <- share(letters)
sharedObjectProperties(x2)
}
