% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packageOptions.R
\name{sharedObjectPkgOptions}
\alias{sharedObjectPkgOptions}
\title{Get or set the global options for the SharedObject package}
\usage{
sharedObjectPkgOptions(..., literal = TRUE)
}
\arguments{
\item{...}{The name of the option(s), it can be either symbols or characters.
if the argument is missing, it means getting all option. See examples.}

\item{literal}{Whether the parameters in \code{...} are always treated as characters.}
}
\value{
\code{set}: The old package options

\code{get}: A list of the package options or a single value
}
\description{
Get or set the global options for the SharedObject package
}
\examples{
## Get all options
sharedObjectPkgOptions()

## Get copyOnWrite only
sharedObjectPkgOptions(copyOnWrite)
sharedObjectPkgOptions("copyOnWrite")
opt <- "copyOnWrite"
sharedObjectPkgOptions(opt, literal = FALSE)


## Set options
sharedObjectPkgOptions(copyOnWrite = FALSE)
## Check if we have changed the option
sharedObjectPkgOptions(copyOnWrite)

## Restore the default
sharedObjectPkgOptions(copyOnWrite = TRUE)
}
