% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STATegRa_omicsPCA_methods.R
\name{omicsCompAnalysis}
\alias{omicsCompAnalysis}
\alias{omicsCompAnalysis,list,character,character,numeric,numeric-method}
\title{Components analysis for multiple objects}
\usage{
omicsCompAnalysis(Input, Names, method, Rcommon, Rspecific, 
                         convThres=1e-10, maxIter=600, center=FALSE, 
                         scale=FALSE, weight=FALSE)
}
\arguments{
\item{Input}{List of \code{ExpressionSet} objects, one for each block of data.}

\item{Names}{Character vector giving names for each Input object.}

\item{method}{Method to use for analysis (either "DISCOSCA", "JIVE", or "O2PLS").}

\item{Rcommon}{Number of common components between all blocks}

\item{Rspecific}{Vector giving number of unique components for each input block}

\item{convThres}{Stop criteria for convergence}

\item{maxIter}{Maximum number of iterations}

\item{center}{Character (or FALSE) specifying which (if any) centering will be applied before analysis. Choices are "PERBLOCKS" (each block separately) or "ALLBLOCKS" (all data together).}

\item{scale}{Character (or FALSE) specifying which (if any) scaling will be applied before analysis. Choices are "PERBLOCKS" (each block separately) or "ALLBLOCKS" (all data together).}

\item{weight}{Logical indicating whether weighting is to be done.}
}
\value{
An object of class \code{\link{caClass-class}}.
}
\description{
This function performs a components analysis of object wise omics data to understand the mechanisms that underlay all the data blocks under study (common mechanisms) and the mechanisms underlying each of the data block independently (distinctive mechanisms). This analysis include both, the preprocessing of data and the components analysis by using three different methodologies.
}
\examples{
data("STATegRa_S3")
B1 <- createOmicsExpressionSet(Data=Block1.PCA,pData=ed.PCA,
pDataDescr=c("classname"))
B2 <- createOmicsExpressionSet(Data=Block2.PCA,
                               pData=ed.PCA,pDataDescr=c("classname"))
# Omics components analysis
discoRes <- omicsCompAnalysis(Input=list(B1,B2),Names=c("expr","mirna"),
                              method="DISCOSCA",Rcommon=2,Rspecific=c(2,2),
                              center=TRUE,scale=TRUE,weight=TRUE)
jiveRes <- omicsCompAnalysis(Input=list(B1,B2),Names=c("expr","mirna"),
                             method="JIVE",Rcommon=2,Rspecific=c(2,2),
                             center=TRUE,scale=TRUE,weight=TRUE)
o2plsRes <- omicsCompAnalysis(Input=list(B1,B2),Names=c("expr","mirna"),
                              method="O2PLS",Rcommon=2,Rspecific=c(2,2),
                              center=TRUE,scale=TRUE,weight=TRUE)
}
\author{
Patricia Sebastian Leon
}
