% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rna}
\alias{rna}
\title{Example single-cell RNA-seq differential expression data}
\format{
A data frame or \code{GRanges}-like object with the following required columns:
\describe{
\item{gene_id}{Identifier of the gene. Must be an official gene symbol (e.g., \code{GAPDH})}
\item{avg_log2FC}{Average log2 fold-change of expression for the gene in the specific cell type}
\item{p_val_adj}{Adjusted p-value (e.g., \code{FDR-corrected})}
\item{cell_type}{Cell type or cluster label associated with each measurement (e.g., \code{Acinar})}
}
}
\source{
Precomputed using \code{FindMarkers()} (Wilcoxon test, via Presto if available) on control samples
from the Human Pancreas Analysis Program (HPAP), using paired snATAC-seq and scRNA-seq data
from three non-diabetic human donors.
}
\usage{
data(rna)
}
\description{
A toy example dataset representing single-cell RNA-seq
differential expression results.
Each row corresponds to a gene tested across one or more cell types.
The dataset is formatted as a list of \code{GRanges} objects or
data frames (convertible to \code{GRanges}), where each element contains
differential expression statistics for a specific cell type.
Multiple rows may exist per gene, each representing results in a different cell type.
}
\keyword{datasets}
